ORCA/M Asm65816 2.1.0

0001 F800                       TITLE 'Auto-Start Monitor ROM'
0002 F800
0003 F800              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 F800              ;	by EdAsmCvtIIGS version 1.2d3 on 5/6/91 at 8:29:45 PM
0005 F800
0006 F800              *****************************************
0007 F800              *                                       *
0008 F800              *               APPLE II                *
0009 F800              *              MONITOR II               *
0010 F800              *                                       *
0011 F800              *    Copyright 1978, 1981, 1984-1989    *
0012 F800              *                   by                  *
0013 F800              *          Apple Computer, Inc.         *
0014 F800              *                                       *
0015 F800              *          All Rights Reserved          *
0016 F800              *                                       *
0017 F800              *       S. Wozniak             1977     *
0018 F800              *       A. Baum                1977     *
0019 F800              *       John A            Nov  1978     *
0020 F800              *       R. Auricchio      Sep  1981     *
0021 F800              *       E. Beernink            1984     *
0022 F800              *       E.K. Lai          Sep  1984     *
0023 F800              *       F. Bachman          1985-1987   *
0024 F800              *       Joe Bo              1988-1989   *
0025 F800              *                                       *
0026 F800              *****************************************
0027 F800
0028 F800
0029 F800              PLOT     EQU   *                        ;Maintained entry point $F800
0030 F800 4A                    LSR   A                        ;Y-COORD/2 
0031 F801 08                    PHP                            ;SAVE LSB IN CARRY 
0032 F802 20 47 F8              JSR   GBASCALC                 ;CALC BASE ADR IN GBASL,H 
0033 F805 28                    PLP                            ;RESTORE LSB FROM CARRY 
0034 F806 A9 0F                 LDA   #$0F                     ;MASK $0F IF EVEN 
0035 F808 90 02                 BCC   @1
0036 F80A 69 E0                 ADC   #$E0                     ;MASK $F0 IF ODD 
0037 F80C 85 2E        @1       STA   MASK
0038 F80E              PLOT1    EQU   *                        ;Maintained entry point $F80E
0039 F80E B1 26                 LDA   (GBASL),Y                ;DATA 
0040 F810 45 30                 EOR   COLOR                    ; XOR COLOR 
0041 F812 25 2E                 AND   MASK                     ;  AND MASK 
0042 F814 51 26                 EOR   (GBASL),Y                ;   XOR DATA 
0043 F816 91 26                 STA   (GBASL),Y                ;    TO DATA 
0044 F818 60                    RTS   
0045 F819
0046 F819              HLINE    EQU   *                        ;Maintained entry point $F819
0047 F819 20 00 F8              JSR   PLOT                     ;PLOT SQUARE 
0048 F81C C4 2C        @1       CPY   H2                       ;DONE? 
0049 F81E B0 11                 BCS   RTS1                     ; YES, RETURN 
0050 F820 C8                    INY                            ; NO, INCR INDEX (X-COORD) 
0051 F821 20 0E F8              JSR   PLOT1                    ;PLOT NEXT SQUARE 
0052 F824 90 F6                 BCC   @1                       ;ALWAYS TAKEN 
0053 F826 69 01        VLINEZ   ADC   #$01                     ;NEXT Y-COORD 
0054 F828              VLINE    EQU   *                        ;Maintained entry point $F828
0055 F828 48                    PHA                            ; SAVE ON STACK 
0056 F829 20 00 F8              JSR   PLOT                     ; PLOT SQUARE 
0057 F82C 68                    PLA   
0058 F82D C5 2D                 CMP   V2                       ;DONE? 
0059 F82F 90 F5                 BCC   VLINEZ                   ; NO, LOOP. 
0060 F831 60           RTS1     RTS   
0061 F832
0062 F832              CLRSCR   EQU   *                        ;Maintained entry point $F832
0063 F832 A0 2F                 LDY   #$2F                     ;MAX Y, FULL SCRN CLR 
0064 F834 D0 02                 BNE   CLRSC2                   ;ALWAYS TAKEN 
0065 F836              CLRTOP   EQU   *                        ;Maintained entry point $F836
0066 F836 A0 27                 LDY   #$27                     ;MAX Y, TOP SCRN CLR 
0067 F838 84 2D        CLRSC2   STY   V2                       ;STORE AS BOTTOM COORD FOR VLINE CALLS
0068 F83A A0 27                 LDY   #$27                     ;RIGHTMOST X-COORD (COLUMN) 
0069 F83C A9 00        @1       LDA   #$00                     ;TOP COORD FOR VLINE CALLS 
0070 F83E 85 30                 STA   COLOR                    ;CLEAR COLOR (BLACK) 
0071 F840 20 28 F8              JSR   VLINE                    ;DRAW VLINE 
0072 F843 88                    DEY                            ;NEXT LEFTMOST X-COORD 
0073 F844 10 F6                 BPL   @1                       ;LOOP UNTIL DONE. 
0074 F846 60                    RTS   
0075 F847
0076 F847              GBASCALC EQU   *                        ;Maintained entry point $F847
0077 F847 48                    PHA                            ;FOR INPUT  00DEFGH 
0078 F848 4A                    LSR   A
0079 F849 29 03                 AND   #$03
0080 F84B 09 04                 ORA   #$04                     ;GENERATE GBASH=000001FG 
0081 F84D 85 27                 STA   GBASH
0082 F84F 68                    PLA                            ;AND GBASL=HDEDE000 
0083 F850 29 18                 AND   #$18
0084 F852 90 02                 BCC   @1
0085 F854 69 7F                 ADC   #$7F
0086 F856 85 26        @1       STA   GBASL
0087 F858 0A                    ASL   A
0088 F859 0A                    ASL   A
0089 F85A 05 26                 ORA   GBASL
0090 F85C 85 26                 STA   GBASL
0091 F85E 60                    RTS   
0092 F85F
0093 F85F              NXTCOL   EQU   *                        ;Maintained entry point $F85F
0094 F85F A5 30                 LDA   COLOR                    ;INCREMENT COLOR BY 3 
0095 F861 18                    CLC   
0096 F862 69 03                 ADC   #$03
0097 F864              SETCOL   EQU   *                        ;Maintained entry point $F864
0098 F864 29 0F                 AND   #$0F                     ;SETS COLOR=17*A MOD 16 
0099 F866 85 30                 STA   COLOR
0100 F868 0A                    ASL   A                        ;BOTH HALF BYTES OF COLOR EQUAL 
0101 F869 0A                    ASL   A
0102 F86A 0A                    ASL   A
0103 F86B 0A                    ASL   A
0104 F86C 05 30                 ORA   COLOR
0105 F86E 85 30                 STA   COLOR
0106 F870 60                    RTS   
0107 F871
0108 F871              SCRN     EQU   *                        ;Maintained entry point $F871
0109 F871 4A                    LSR   A                        ;READ SCREEN Y-COORD/2 
0110 F872 08                    PHP                            ;SAVE LSB (CARRY) 
0111 F873 20 47 F8              JSR   GBASCALC                 ;CALC BASE ADDRESS 
0112 F876 B1 26                 LDA   (GBASL),Y                ;GET BYTE 
0113 F878 28                    PLP                            ;RESTORE LSB FROM CARRY 
0114 F879 90 04        SCRN2    BCC   RTMSKZ                   ;IF EVEN, USE LO H 
0115 F87B 4A           SCRN4    LSR   A
0116 F87C 4A                    LSR   A
0117 F87D 4A                    LSR   A                        ;SHIFT HIGH HALF BYTE DOWN 
0118 F87E 4A                    LSR   A
0119 F87F 29 0F        RTMSKZ   AND   #$0F                     ;MASK 4-BITS 
0120 F881 60                    RTS   
0121 F882
0122 F882              DBTOE1   EQU   *                        ;Change data bank register to E1
0123 F882 F4 E1 E1              PEA   $E1E1                    ;Change data bank register to E1
0124 F885 AB                    PLB                            ;Dummy pull
0125 F886 AB                    PLB                            ;Sets data bank register to E1
0126 F887 60                    RTS                            ;
0127 F888
0128 F888              GONEWGETNUM EQU   *                     ;Used by monitor
0129 F888 A0 94                 LDY   #$94                     ;'Y'=$94 for new GETNUM routine
0130 F88A 80 10                 BRA   GOTOBANKFF               ;Return to caller via this way
0131 F88C
0132 F88C                       FillTo $F88C                   ;Pad
0133 F88C
0134 F88C              INSDS1_2 EQU   *                        ;Maintained entry point $F88C
0135 F88C A1 3A                 LDA   (PCL,X)                  ;Here for user programs only
0136 F88E
0137 F88E                       FillTo $F88E                   ;Pad
0138 F88E
0139 F88E              * INSDS2 returns the length of opcodes.  All opcodes
0140 F88E              * lengths-1 are returned in LENGTH.  On entry the opcode
0141 F88E              * to determine the length of is in 'A'.
0142 F88E              *
0143 F88E              * For compatibility reasons with DOS 3.3's relocator
0144 F88E              * and for historical reasons INSDS2 must return the
0145 F88E              * length of 6502 instructions and a length of 1
0146 F88E              * byte for non 6502 instructions.
0147 F88E              *
0148 F88E              * GET816LEN performs the same function as INSDS2 except
0149 F88E              * it properly returns the length of all 65816 instructions.
0150 F88E
0151 F88E              INSDS2   EQU   *                        ;Maintained entry point $F88E
0152 F88E 38                    SEC                            ;Indicate 6502 instruction lens wanted
0153 F88F 90                    OPCODE BCC                     ;Go do routine
0154 F890
0155 F890              GET816LEN EQU   *                       ;Maintained entry point $F890
0156 F890 18                    CLC                            ;Indicate 65816 instructions lens wanted
0157 F891 4C CC FF              JMP   GETLENGTH                ;Go do routine
0158 F894
0159 F894
0160 F894              DOFFCOUT EQU   *                        ;Called from bank FF to do COUT
0161 F894 4C D1 A9              JMP   COUTFF                   ;Go thru anti dispatcher to output char
0162 F897
0163 F897              DOFFCOUT1 EQU   *                       ;Called from bank FF to do COUT1
0164 F897 4C D6 A9              JMP   COUT1FF                  ;Go thru anti dispatcher to output char
0165 F89A
0166 F89A
0167 F89A              DONEWBELL2 EQU   *
0168 F89A A0 A0                 LDY   #$A0                     ;'Y'=A0 for new speaker BELL1 routine
0169 F89C
0170 F89C
0171 F89C              GOTOBANKFF EQU   *                      ;Go execute routine in bank $FF
0172 F89C 08                    PHP                            ;Save user status bits first
0173 F89D 18                    CLC                            ;Now switch to native 65816 mode
0174 F89E FB                    XCE                            ;
0175 F89F 28                    PLP                            ;Restore user interrupt status now
0176 F8A0 E2 30                 SEP   #$30                     ;Set m/x to 8 bit mode
0177 F8A2 48                    PHA                            ;Save user's 'A'
0178 F8A3 AD 36 C0              LDA   CYAREG                   ;Save speed status
0179 F8A6 48                    PHA                            ;
0180 F8A7 09 80                 ORA   #$80                     ; and switch to hi speed
0181 F8A9 8D 36 C0              STA   CYAREG                   ;
0182 F8AC 22 98 01 E1           JSL   >MDISPATCH               ;Off to bank $FF
0183 F8B0 68                    PLA                            ;Return here and restore user speed
0184 F8B1 8D 36 C0              STA   CYAREG                   ;
0185 F8B4 68                    PLA                            ;Recall new 'A'
0186 F8B5
0187 F8B5              MAINSIDE EQU   *                        ;Called from bank FE/FF ROM space
0188 F8B5 08                    PHP                            ;Now switch back to emulation mode
0189 F8B6 38                    SEC                            ;
0190 F8B7 FB                    XCE                            ;
0191 F8B8 28                    PLP                            ;Now restore subroutine's status
0192 F8B9 60                    RTS                            ;Back to caller
0193 F8BA
0194 F8BA
0195 F8BA              SETMEMORY00 EQU   *                     ;Memory fill routine so DOS will boot
0196 F8BA 9C 00 08              STZ   $800                     ;Pattern to fill memory with
0197 F8BD                       LONGA ON
0198 F8BD                       LONGI ON
0199 F8BD 18                    CLC                            ;
0200 F8BE FB                    XCE                            ;
0201 F8BF C2 30                 REP   #$30                     ;16 bit mode a must
0202 F8C1 A2 00 08              LDX   #$800                    ;Starting address
0203 F8C4 9B                    TXY                            ;Destination address equals starting
0204 F8C5 C8                    INY                            ; address+1
0205 F8C6 A9 FE B7              LDA   #$B7FE                   ;Number of bytes to move
0206 F8C9 54 00 00              MVN   0,0                      ;Source bank,destination bank
0207 F8CC 80 E7                 BRA   MAINSIDE                 ;Return to emulation mode and exit
0208 F8CE                       LONGA OFF
0209 F8CE                       LONGI OFF
0210 F8CE
0211 F8CE
0212 F8CE                       FillTo $F8D0                   ;Pad
0213 F8D0
0214 F8D0              INSTDSP  EQU   *                        ;Maintained entry point $F8D0
0215 F8D0 A0 99                 LDY   #$99                     ;'Y'=$99 for DISASEM 
0216 F8D2 80 C8                 BRA   GOTOBANKFF               ;Disassemble 1 instruction
0217 F8D4
0218 F8D4              MAINEXIT EQU   *                        ;Called from bank FE/FF ROM space
0219 F8D4 08                    PHP                            ;Save processor status
0220 F8D5 18                    CLC                            ;Make shift back to native mode
0221 F8D6 FB                    XCE                            ;
0222 F8D7 28                    PLP                            ;Restore processor status
0223 F8D8 6B                    RTL                            ;Back to calling bank
0224 F8D9
0225 F8D9              * SPATFNS is called by Applesoft (with a JSR) and
0226 F8D9              * is an extension of the HLIN routine to fix
0227 F8D9              * horizontal/vertical range checking.
0228 F8D9
0229 F8D9              SPATFNS  EQU   *                        ;Maintained entry point $F8D9
0230 F8D9 20 F8 E6              JSR   GETBYT                   ;Get first argument
0231 F8DC E0 50                 CPX   #80                      ;HLIN allows max value here of 79
0232 F8DE B0 11                 BCS   @2                       ;'c'=1 then value entered is too big
0233 F8E0 86 F0                 STX   FIRST                    ;Save for Applesoft
0234 F8E2 20 BE DE              JSR   CHKCOM                   ;Parse check for a ','
0235 F8E5 20 F8 E6              JSR   GETBYT                   ;Get second argument
0236 F8E8 E0 50                 CPX   #80                      ;HLIN allows max value here of 79
0237 F8EA 86 2C                 STX   H2                       ;Save for Applesoft
0238 F8EC 86 2D                 STX   V2                       ; in Applesoft variable space.
0239 F8EE 4C 0C F2              JMP   ATFNS2                   ;Continue in Applesoft
0240 F8F1
0241 F8F1              @2       EQU   *
0242 F8F1 4C 06 F2              JMP   TOOBIG                   ;Continue with range error in Applesoft
0243 F8F4
0244 F8F4              NEWRESET2 EQU   *
0245 F8F4 20 BA F8              JSR   SETMEMORY00              ;Fix up memory for DOS
0246 F8F7 20 58 FC              JSR   HOME                     ;Clear the screen
0247 F8FA A0 A4                 LDY   #$A4                     ;Print title and copyright msg
0248 F8FC 20 9C F8              JSR   GOTOBANKFF               ;Go to bankff 
0249 F8FF A0 9D                 LDY   #$9D                     ;Do some more coldstart stuff
0250 F901 20 9C F8              JSR   GOTOBANKFF               ;Go to bank FF
0251 F904 20 DB F9              JSR   ENBDATAREG               ;Enable ints for Desk Accessory Manager
0252 F907
0253 F907 AF 41 01 E1           LDA   >EXTENDBNK+1             ;BUTN1 ;Get button 1 (Solid-Apple)
0254 F90B 30 01                 BMI   SHOWCP                   ;=>Up, then user wants normal powerup
0255 F90D              JUMPERON EQU   *
0256 F90D 60                    RTS                            ;Back to caller
0257 F90E
0258 F90E              SHOWCP   EQU   *                        ;=>Down, then user wants control panel
0259 F90E              *
0260 F90E AF A5 01 E1           LDA   >GSC                     ;Added 2/10/89 MSA to check TS Jumper
0261 F912 0A                    ASL   A                        ;We're interested in bit 6
0262 F913 30 F8                 BMI   JUMPERON                 ;If TS Jumper, don't allow special CP entry
0263 F915              *
0264 F915 18                    CLC                            ;Switch to native mode
0265 F916 FB                    XCE                            ; with 8 bit 'm'/'x'
0266 F917 22 3B 8F FF           JSL   >SPEC_PANEL              ;
0267 F91B 38                    SEC                            ;
0268 F91C FB                    XCE                            ;Back to emulation mode to restart system
0269 F91D 4C 62 FA              JMP   RESET                    ;
0270 F920
0271 F920
0272 F920              TRYAPTALK EQU   *                       ;Call from 'MAYBEAPTALK' routine
0273 F920 AF C1 01 E1           LDA   >APTALKBOOT              ;Check AppleTalk boot byte
0274 F924 F0 0A                 BEQ   @2                       ;Slot1/2 none selected for ApTalk
0275 F926 C9 02                 CMP   #$02                     ;Is it slot2 AppleTalk ?
0276 F928 D0 03                 BNE   @1                       ;Bra to boot from slot1
0277 F92A 4C E0 C2              JMP   BOOTAPTALK2              ;Boot from AppleTalk via slot2
0278 F92D              @1       EQU   *
0279 F92D 4C E0 C1              JMP   BOOTAPTALK1              ;Boot from AppleTalk via slot1
0280 F930
0281 F930              @2       EQU   *
0282 F930 4C F8 FA              JMP   NODISK                   ;Display 'Check Startup Device' msg
0283 F933
0284 F933
0285 F933              ;NEWCNTLT EQU *
0286 F933              ;LDA =FLIPSCRN ;
0287 F933              ;EOR #$80
0288 F933              ;STA =FLIPSCRN ;
0289 F933              ;LDY #$A9
0290 F933              ;JMP GOTOBANKFF ;
0291 F933
0292 F933                       FillTo $F93A                   ;Pad
0293 F93A
0294 F93A              GETAN3STATUS EQU   *                    ;Maintained entry point $F93A
0295 F93A AD 46 C0              LDA   INTFLAG                  ;Get AN3 status in bit 5
0296 F93D 0A                    ASL   A                        ;Move status to bit 7 for AppleSoft
0297 F93E 0A                    ASL   A                        ;
0298 F93F 60                    RTS                            ;Back to caller
0299 F940
0300 F940              PRNTYX   EQU   *                        ;Maintained entry point $F940
0301 F940 98                    TYA                            ;
0302 F941              PRNTAX   EQU   *                        ;Maintained entry point $F941
0303 F941 20 DA FD              JSR   PRBYTE                   ;OUTPUT TARGET ADR 
0304 F944              PRNTX    EQU   *                        ;Maintained entry point $F944
0305 F944 8A                    TXA                            ;  OF BRANCH AND RETURN 
0306 F945 4C DA FD              JMP   PRBYTE
0307 F948
0308 F948              PRBLNK   EQU   *                        ;Maintained entry point $F948
0309 F948 A2 03                 LDX   #$03                     ;BLANK COUNT 
0310 F94A              PRBL2    EQU   *                        ;Maintained entry point $F94A
0311 F94A A9 A0                 LDA   #$A0                     ;LOAD A SPACE 
0312 F94C 20 ED FD              JSR   COUT                     ;OUTPUT A BLANK 
0313 F94F CA                    DEX   
0314 F950 D0 F8                 BNE   PRBL2                    ;LOOP UNTIL COUNT=0   
0315 F952 60                    RTS   
0316 F953
0317 F953              PCADJ    EQU   *                        ;Maintained entry point $F953
0318 F953 38                    SEC                            ;0=1 BYTE, 1=2 BYTE, 
0319 F954 A5 2F                 LDA   LENGTH                   ;  2=3 BYTE 
0320 F956 A4 3B        PCADJ3   LDY   PCH
0321 F958 AA                    TAX                            ;TEST DISPLACEMENT SIGN 
0322 F959 10 01                 BPL   @1                       ;  (FOR REL BRANCH) 
0323 F95B 88                    DEY                            ;EXTEND NEG BY DECR PCH 
0324 F95C 65 3A        @1       ADC   PCL
0325 F95E 90 01                 BCC   @2                       ;PCL+LENGTH(OR DISPL)+1 TO A 
0326 F960 C8                    INY                            ;  CARRY INTO Y (PCH) 
0327 F961 60           @2       RTS   
0328 F962
0329 F962              *
0330 F962              * Due to limited space, differentiation between Gyro 
0331 F962              * and gs can't insert here, thus move TEXT2COPY to
0332 F962              * TEXT2COPYFF.  Entry point must be maintained.
0333 F962              *
0334 F962              * This routine installs a heartbeat task
0335 F962              * that copies text page 2 to bank E0 for
0336 F962              * the Mega // to display on every VBL.
0337 F962              *
0338 F962              * This is a toggle (enable/disable) routine.
0339 F962              * If auto text copy is on, on entry, it is disabled on exit.
0340 F962              * If auto text copy is off, on entry, it is enabled on exit.
0341 F962              *
0342 F962
0343 F962                       FillTo $F962                   ;Pad
0344 F962
0345 F962              TEXT2COPY EQU   *                       ;Maintained entry point $F962
0346 F962 A0 A6                 LDY   #$A6                     ;'Y' = $A6 for TEXT2COPYFF
0347 F964 4C 9C F8              JMP   GOTOBANKFF               ;Go and do it in bank ff
0348 F967
0349 F967              SETP2REG EQU   *                        ;Set bit5 of $c035 from TP2MODE
0350 F967 A0 A7                 LDY   #$A7                     ;'Y' = $A7 for settext2reg
0351 F969 4C 9C F8              JMP   GOTOBANKFF               ;
0352 F96C
0353 F96C
0354 F96C              GETLENGTH1 EQU   *
0355 F96C 5A                    PHY                            ;Preserve Y for the user
0356 F96D A0 9A                 LDY   #$9A                     ;'Y'=$9A for INSDS3
0357 F96F 90 02                 BCC   GETLENGTH2               ;'c'= 1 for 6502 lengths
0358 F971 A0 9F                 LDY   #$9F                     ;'Y'=$9F for 6502 instruction lengths
0359 F973              GETLENGTH2 EQU   *
0360 F973 20 9C F8              JSR   GOTOBANKFF               ;Go do routine
0361 F976 7A                    PLY                            ;Restore Y for the user
0362 F977 60                    RTS                            ;Back to caller
0363 F978
0364 F978              NOTCR3   EQU   *
0365 F978 EB                    XBA                            ;Preserve output character or suffer
0366 F979 AF 37 01 E1           LDA   >CHGCURFLG               ;Test bit 0 for don't count flag
0367 F97D 4A                    LSR   A                        ;'c'=0 then continue normally
0368 F97E 90 06                 BCC   @1                       ;
0369 F980 D0 04                 BNE   @1                       ;If 'z'=1 then clear CHGCURFLG
0370 F982 8F 37 01 E1           STA   >CHGCURFLG               ;
0371 F986              @1       EQU   *
0372 F986 EB                    XBA                            ;Restore output character or suffer
0373 F987 60                    RTS                            ;'c'=1 then don't count in input buffer.
0374 F988
0375 F988
0376 F988
0377 F988                       TITLE 'Auto-Start Monitor ROM'
0378 F988              *****************************************
0379 F988              *                                       *
0380 F988              *               APPLE II                *
0381 F988              *              MONITOR II               *
0382 F988              *                                       *
0383 F988              *    Copyright 1978, 1981, 1984-1989    *
0384 F988              *                   by                  *
0385 F988              *          Apple Computer, Inc.         *
0386 F988              *                                       *
0387 F988              *          All Rights Reserved          *
0388 F988              *                                       *
0389 F988              *       S. Wozniak             1977     *
0390 F988              *       A. Baum                1977     *
0391 F988              *       John A            Nov  1978     *
0392 F988              *       R. Auricchio      Sep  1981     *
0393 F988              *       E. Beernink            1984     *
0394 F988              *       E.K. Lai          Sep  1984     *
0395 F988              *       F. Bachman          1985-1987   *
0396 F988              *       Joe Bo              1988-1989   *
0397 F988              *                                       *
0398 F988              *****************************************
0399 F988
0400 F988
0401 F988 BC           CHRTBL   DC B:$BC                       ;'^C' (BASIC warm start) 
0402 F989 B2                    DC B:$B2                       ;'^Y' (USeR vector) 
0403 F98A BE                    DC B:$BE                       ;'^E' (Examine registers) 
0404 F98B 9A                    DC B:$9A                       ;'!'  (Enter mini-assembler) 
0405 F98C EF                    DC B:$EF                       ;'V'  (Memory verify) 
0406 F98D C4                    DC B:$C4                       ;'^K' (IN#slot) 
0407 F98E E9                    DC B:$E9                       ;'P'  (Pattern search)
0408 F98F A9                    DC B:$A9                       ;'^P' (PR#slot) 
0409 F990 BB                    DC B:$BB                       ;'^B' (BASIC cold start) 
0410 F991 A6                    DC B:$A6                       ;'-'  (Subtract) 
0411 F992 A4                    DC B:$A4                       ;'+'  (Add) 
0412 F993 06                    DC B:$06                       ;'M'  (Memory move) 
0413 F994 95                    DC B:$95                       ;'<'  (Delimiter for move, verify)
0414 F995 07                    DC B:$07                       ;'N'  (Set normal video) 
0415 F996 02                    DC B:$02                       ;'I'  (Set inverse video) 
0416 F997 05                    DC B:$05                       ;'L'  (Disassemble instructions)
0417 F998 00                    DC B:$00                       ;'G'  (JSR subroutine and return to mon)
0418 F999 F1                    DC B:$F1                       ;'X'  (JSL subroutine and return to mon)
0419 F99A EB                    DC B:$EB                       ;'R'  (JMP subroutine and do not return)
0420 F99B 93                    DC B:$93                       ;':'  (Memory fill)
0421 F99C A7                    DC B:$A7                       ;'.'  (Address delimiter) 
0422 F99D C6                    DC B:$C6                       ;'CR' (End of input) 
0423 F99E 99                    DC B:$99                       ;' '  (Blank) 
0424 F99F 96                    DC B:$96                       ;'='  (New commands delimiter)
0425 F9A0 ED                    DC B:$ED                       ;'T'  (Trace)
0426 F9A1 EC                    DC B:$EC                       ;'S'  (Step)
0427 F9A2 9B                    DC B:$9B                       ;'"'  (Literal ASCII input mode)
0428 F9A3 F5                    DC B:$F5                       ;'\'  (Start/end of pattern to search for)
0429 F9A4 F3                    DC B:$F3                       ;'Z'  (Zap memory)
0430 F9A5 EA                    DC B:$EA                       ;'Q'  (Quit monitor via JMP $3D0)
0431 F9A6 EE                    DC B:$EE                       ;'U'  (Utility call to Tool Locator)
0432 F9A7 AB                    DC B:$AB                       ;'^R' (Restore registers)
0433 F9A8 AD                    DC B:$AD                       ;'^T' (Go to Text page 1)
0434 F9A9 A3                    DC B:$A3                       ;'*'  (Multiply)
0435 F9AA F8                    DC B:$F8                       ;'_'  (Divide)
0436 F9AB 9C                    DC B:$9C                       ;'#'  (Enable monitor desk accessory)
0437 F9AC C7                    DC B:$C7                       ;'^N' (Set internal 'm'/'x'/'e' = 0)
0438 F9AD
0439 F9AD              CHRTBLLEN EQU   *-CHRTBL-1              ;Length of character table
0440 F9AD
0441 F9AD              * Table of low order monitor routine dispatch 
0442 F9AD              * addresses.  High byte always $FE
0443 F9AD
0444 F9AD AC           SUBTBL   DC B:BASCONT-1                 ;'^C' (BASIC warm start) 
0445 F9AE 12                    DC B:USR-1                     ;'^Y' (USeR vector)
0446 F9AF C9                    DC B:NEWREGZ-1                 ;'^E' (Examine registers) 
0447 F9B0 DA                    DC B:MINI-1                    ;'!'  (Enter mini-assembler)
0448 F9B1 DB                    DC B:XVERIFY-1                 ;'V'  (Memory verify) 
0449 F9B2 8C                    DC B:INPRT-1                   ;'^K' (IN#slot) 
0450 F9B3 DD                    DC B:SEARCH-1                  ;'P'  (Pattern search)
0451 F9B4 96                    DC B:OUTPRT-1                  ;'^P' (PR#slot) 
0452 F9B5 EB                    DC B:XBASIC-1                  ;'^B' (BASIC cold start) 
0453 F9B6 0A                    DC B:SETMODE-1                 ;'-'  (Subtract)
0454 F9B7 0A                    DC B:SETMODE-1                 ;'+'  (Add)
0455 F9B8 DC                    DC B:XMOVE-1                   ;'M'  (Memory move) 
0456 F9B9 FD                    DC B:LT-1                      ;'<'  (Delimiter for move,verify) 
0457 F9BA 83                    DC B:SETNORM-1                 ;'N'  (Set normal video) 
0458 F9BB 7F                    DC B:SETINV-1                  ;'I'  (Set inverse video) 
0459 F9BC D4                    DC B:LIST-1                    ;'L'  (Disassemble instructions)
0460 F9BD D0                    DC B:GO816-1                   ;'G'  (JSR subroutine and return to mon)
0461 F9BE CF                    DC B:X816-1                    ;'X'  (JSL subroutine and return to mon)
0462 F9BF D6                    DC B:RESUME-1                  ;'R'  (JMP subroutine and do not return)
0463 F9C0 0A                    DC B:SETMODE-1                 ;':'  (Memory fill) 
0464 F9C1 0A                    DC B:SETMODE-1                 ;'.'  (Address delimiter) 
0465 F9C2 F5                    DC B:CRMON-1                   ;'CR' (End of input) 
0466 F9C3 00                    DC B:BLANK-1                   ;' '  (Blank)
0467 F9C4 D5                    DC B:EQUALS-1                  ;'='  (New commands delimiter)
0468 F9C5 D8                    DC B:TRACE-1                   ;'T'  (Trace)
0469 F9C6 D7                    DC B:STEP-1                    ;'S'  (Step)
0470 F9C7 D1                    DC B:LITASC-1                  ;'"'  (Literal ASCII input mode)
0471 F9C8 D3                    DC B:PTRNSET-1                 ;'\'  (Start/end of pattern to search for)
0472 F9C9 D2                    DC B:CMDZAP-1                  ;'Z'  (Zap memory)
0473 F9CA BE                    DC B:QUITMON-1                 ;'Q'  (Quit monitor via JMP $3D0)
0474 F9CB CE                    DC B:UTILITY-1                 ;'U'  (Utility call to Tool Locator)
0475 F9CC E0                    DC B:REGSET-1                  ;'^R' (Restore registers)
0476 F9CD 52                    DC B:GOTXT11-1                 ;'^T' (Go to Text page 1)
0477 F9CE 0A                    DC B:SETMODE-1                 ;'*'  (Multiply)
0478 F9CF 0A                    DC B:SETMODE-1                 ;'_'  (Divide)
0479 F9D0 B3                    DC B:MONDSKACC-1               ;'#'  (Enable monitor desk accessory)
0480 F9D1 CD                    DC B:MAKENATIVE-1              ;'^N' (Set internal 'm'/'x'/'e' = 0)
0481 F9D2
0482 F9D2
0483 F9D2              WARMUPAPTALK EQU   *                    ;Warm start AppleTalk and continue
0484 F9D2 18                    CLC                            ;Switch to native mode to do this
0485 F9D3 FB                    XCE                            ;
0486 F9D4 08                    PHP                            ;Be sure to save entry status
0487 F9D5 22 10 00 FE           JSL   >APTALKRESET             ;Warm start AppleTalk
0488 F9D9 28                    PLP                            ;Restore entry status
0489 F9DA FB                    XCE                            ;
0490 F9DB
0491 F9DB              ENBDATAREG EQU   *                      ;Enable data register ints for DA manager
0492 F9DB 78                    SEI                            ;Disable interrupts briefly
0493 F9DC A9 10                 LDA   #$10                     ;Enables data register interrupt
0494 F9DE 0C 27 C0              TSB   KMSTATUS                 ; via key glue.
0495 F9E1 58                    CLI                            ;Enable system interrupts
0496 F9E2
0497 F9E2              D2D      EQU   *                        ;Disk ][ detect
0498 F9E2 AF 39 01 E1           LDA   >SLOTSFLG                ;Setup SLTROMSEL correctly for warm start
0499 F9E6 8D 2D C0              STA   SLTROMSEL                ;
0500 F9E9 A4 00                 LDY   LOC0                     ;Save zero page bytes used on stack
0501 F9EB 5A                    PHY                            ;
0502 F9EC A4 01                 LDY   LOC1                     ;Save zero page bytes used on stack
0503 F9EE 5A                    PHY                            ;
0504 F9EF A9 00                 LDA   #$00                     ;Setup byte to map in Disk ][ detects
0505 F9F1 48                    PHA                            ;Save for later
0506 F9F2 A9 C8                 LDA   #$C8                     ;Use zero page for this test
0507 F9F4 64 00                 STZ   LOC0                     ;Lo byte is 0
0508 F9F6 85 01                 STA   LOC1                     ;Hi byte is in 'A'
0509 F9F8              @1       EQU   *
0510 F9F8 18                    CLC                            ;Clear a bit
0511 F9F9              @2       EQU   *                        ;'c'=1 if branch to here
0512 F9F9 68                    PLA                            ;
0513 F9FA 2A                    ROL   A                        ;Shift in a bit
0514 F9FB 48                    PHA                            ;Save on stack again
0515 F9FC A0 05                 LDY   #$05                     ;Test starting at 6th byte
0516 F9FE C6 01                 DEC   LOC1                     ;Change slot pointer
0517 FA00 A5 01                 LDA   LOC1                     ;Test if done
0518 FA02 C9 C4                 CMP   #$C4                     ;Done if decremented to slot 3
0519 FA04 90 14                 BCC   @5                       ;
0520 FA06              @3       EQU   *
0521 FA06 B1 00                 LDA   (LOC0),Y                 ;Test 1st I.D. byte
0522 FA08 D9 01 FB              CMP   DISKID-1,Y               ; against disk ][ bytes.
0523 FA0B D0 EB                 BNE   @1                       ;<>= then try next slot
0524 FA0D 88                    DEY                            ;Try next I.D. byte
0525 FA0E 88                    DEY                            ;
0526 FA0F 10 F5                 BPL   @3                       ;Loop
0527 FA11 B1 00                 LDA   (LOC0),Y                 ;'Y'=$FF if here
0528 FA13 F0 E4                 BEQ   @2                       ;= then it's a disk ][
0529 FA15 1A                    INC   A                        ;If value now 0 it's also a disk ][
0530 FA16 D0 E0                 BNE   @1                       ;Try next slot
0531 FA18 F0 DF                 BEQ   @2                       ;= then it's a disk ][
0532 FA1A
0533 FA1A              @5       EQU   *
0534 FA1A 68                    PLA                            ;Recall status byte
0535 FA1B 7A                    PLY                            ;Recall zero page bytes used
0536 FA1C 84 01                 STY   LOC1                     ;Restore zero page bytes used
0537 FA1E 7A                    PLY                            ;Recall zero page bytes used
0538 FA1F 84 00                 STY   LOC0                     ;Restore zero page bytes used
0539 FA21 4C DB FF              JMP   FIXSPEED2                ;Set up CYAREG
0540 FA24
0541 FA24
0542 FA24              T480CARD EQU   *                        ;Test for possible 80 column card
0543 FA24 AF D9 02 E1           LDA   >USERCOL                 ;0=40 columns <>0=80 columns
0544 FA28 D0 02                 BNE   T480CARD2                ;<>= then test for ROM in slot 3
0545 FA2A 1A                    INC   A                        ;=0 then make <>0
0546 FA2B 60                    RTS                            ;Indicate use 40 columns
0547 FA2C
0548 FA2C              T480CARD2 EQU   *
0549 FA2C A2 00                 LDX   #$00                     ;Preset counter to $00
0550 FA2E              @2       EQU   *
0551 FA2E AD 05 C3              LDA   C300+5+0                 ;Test for match
0552 FA31 C9 38                 CMP   #$38                     ;
0553 FA33 D0 0A                 BNE   @3                       ;<>= then no card installed
0554 FA35 AD 07 C3              LDA   C300+7                   ;Test for another match
0555 FA38 C9 18                 CMP   #$18                     ;
0556 FA3A D0 03                 BNE   @3                       ;<>= then no card installed
0557 FA3C E8                    INX                            ;Try many times to be sure
0558 FA3D D0 EF                 BNE   @2                       ;Loop for another try
0559 FA3F              @3       EQU   *                        ;Exit here
0560 FA3F 60                    RTS                            ;= then use 80 cols/ <>= then use 40 cols
0561 FA40
0562 FA40
0563 FA40                       FillTo $FA40                   ;Pad
0564 FA40
0565 FA40              OLDIRQ   EQU   *                        ;Maintained entry point $FA40
0566 FA40 4C 74 C0              JMP   TOEBRKIRQ                ;Go to new interrupt handler
0567 FA43
0568 FA43              OLDBRK2  EQU   *
0569 FA43 20 3A FF              JSR   BELL                     ;Ring the bells
0570 FA46 20 DB F9              JSR   ENBDATAREG               ;Turn on ints/switch system to user spd
0571 FA49 4C 6C FF              JMP   MONZ2                    ;Skip register reset
0572 FA4C
0573 FA4C                       FillTo $FA4C                   ;Pad
0574 FA4C
0575 FA4C              BREAK    EQU   *                        ;Maintained entry point $FA4C
0576 FA4C 28                    PLP                            ;
0577 FA4D 20 4C FF              JSR   SAV1                     ;SAVE REG'S ON BREAK 
0578 FA50 68                    PLA                            ; INCLUDING PC 
0579 FA51 85 3A                 STA   PCL
0580 FA53 68                    PLA   
0581 FA54 85 3B                 STA   PCH
0582 FA56              GOBRK~Bnk00 EQU   *-Rel~Org+Bnk~Org     ;Called by interrupt code
0583 FA56 6C F0 03              JMP   (BRKV)                   ;BRKV WRITTEN OVER BY DISK BOOT
0584 FA59
0585 FA59              OLDBRK   EQU   *                        ;Maintained entry point $FA59
0586 FA59 A0 93                 LDY   #$93                     ;Print user instruction of break
0587 FA5B 20 9C F8              JSR   GOTOBANKFF               ; and register display
0588 FA5E 80 E3                 BRA   OLDBRK2                  ;Go to pseudo monitor start
0589 FA60
0590 FA60                       FillTo $FA62                   ;Pad
0591 FA62
0592 FA62              RESET    EQU   *                        ;Maintained entry point $FA62
0593 FA62 A9 01                 LDA   #$01                     ;Enable read alt mem with long inst
0594 FA64 0C 29 C0              TSB   NEWVIDEO                 ;
0595 FA67
0596 FA67                       FillTo $FA67,$EA               ;Pad
0597 FA67
0598 FA67              FBBYTE   EQU   *+1                      ;Maintained entry point $FF68
0599 FA67 A9 FB                 LDA   #$FB                     ;FBBYTE must be $FB for compatibility
0600 FA69 78                    SEI                            ;In case user calls into here
0601 FA6A D8                    CLD                            ;Do this on every reset
0602 FA6B 1B                    TCS                            ;Must reset the stack
0603 FA6C 20 36 FE              JSR   NEWRESET                 ;New reset routine
0604 FA6F A9 0C                 LDA   #$0C                     ;Set up //e memory state
0605 FA71 8D 68 C0              STA   STATEREG                 ; or else die later.
0606 FA74 A0 09                 LDY   #9                       ;CODE=INIT
0607 FA76 20 9C F8              JSR   GOTOBANKFF               ;Do new machine init code
0608 FA79 AD FF CF              LDA   CLRROM                   ; TURN OFF EXTNSN ROM
0609 FA7C 2C 10 C0              BIT   KBDSTRB                  ; CLEAR KEYBOARD
0610 FA7F
0611 FA7F 20 24 FA              JSR   T480CARD                 ;Does user want 40 or 80 columns?
0612 FA82 D0 03                 BNE   @1                       ;
0613 FA84 20 12 FD              JSR   TSTFORCUR4               ;Switch user to 80 column mode
0614 FA87              @1       EQU   *                        ;Don't change video output mode
0615 FA87
0616 FA87 20 9A F8              JSR   DONEWBELL2               ; CAUSES DELAY IF KEY BOUNCES
0617 FA8A AD F3 03              LDA   SOFTEV+1                 ;IS RESET HI
0618 FA8D 49 A5                 EOR   #$A5                     ;A FUNNY COMPLEMENT OF THE
0619 FA8F CD F4 03              CMP   PWREDUP                  ; PWR UP BYTE ?
0620 FA92 D0 12                 BNE   PWRUP                    ; NO SO PWRUP
0621 FA94 AD F2 03              LDA   SOFTEV                   ; YES SEE IF COLD START
0622 FA97 D0 42                 BNE   NOFIX                    ; HAS BEEN DONE YET?
0623 FA99 A9 E0                 LDA   #$E0                     ; DOES SOFT ENTRY VECTOR POINT AT BASIC? 
0624 FA9B CD F3 03              CMP   SOFTEV+1
0625 FA9E D0 3B                 BNE   NOFIX                    ; YES SO REENTER SYSTEM
0626 FAA0 A0 03                 LDY   #3                       ; NO SO POINT AT WARM START FOR NEXT RESET
0627 FAA2 4C E6 FE              JMP   NEWFIXSEV                ; DO THE COLD START
0628 FAA5
0629 FAA5
0630 FAA5                       FillTo $FAA6                   ;Pad
0631 FAA6
0632 FAA6              PWRUP    EQU   *                        ;Maintained entry point $FAA6
0633 FAA6 20 F4 F8              JSR   NEWRESET2                ;Clear memory+show 'Apple II' on screen
0634 FAA9
0635 FAA9              *  Set up page 3 vectors.
0636 FAA9
0637 FAA9 A2 05                 LDX   #5
0638 FAAB BD FC FA     @1       LDA   PWRCON-1,X               ; WITH CNTRL B ADRS
0639 FAAE 9D EF 03              STA   BRKV-1,X                 ; OF CURRENT BASIC
0640 FAB1 CA                    DEX   
0641 FAB2 D0 F7                 BNE   @1
0642 FAB4 80 2B                 BRA   WHO2BOOT                 ;Who to boot?
0643 FAB6
0644 FAB6              SETPLP2  EQU   *
0645 FAB6 85 01                 STA   LOC1                     ; SET PTR H
0646 FAB8 64 00                 STZ   LOC0                     ;Assure low byte of pointer is 0
0647 FABA
0648 FABA              * Check 3 ID bytes instead of 4.  Allows devices
0649 FABA              * other than Disk II's to be bootable.
0650 FABA
0651 FABA              SLOOP    EQU   *                        ;Maintained entry point $FABA
0652 FABA A0 05                 LDY   #5                       ;Y is byte ptr
0653 FABC C6 01                 DEC   LOC1
0654 FABE A9 00                 LDA   #0                       ;MUST have 0 at $FABF to match 0 at $FAFF
0655 FAC0 A5 01                 LDA   LOC1
0656 FAC2 C9 C0                 CMP   #$C0                     ; AT LAST SLOT YET?
0657 FAC4 F0 32                 BEQ   NODISK                   ; YES AND IT CAN'T BE A DISK
0658 FAC6 8D F8 07              STA   MSLOT
0659 FAC9 B1 00        @1       LDA   (LOC0),Y                 ; FETCH A SLOT BYTE
0660 FACB D9 01 FB              CMP   DISKID-1,Y               ; IS IT A DISK ??
0661 FACE D0 EA                 BNE   SLOOP                    ; NO, SO NEXT SLOT DOWN
0662 FAD0 88                    DEY   
0663 FAD1 88                    DEY                            ; YES, SO CHECK NEXT BYTE
0664 FAD2 10 F5                 BPL   @1                       ; UNTIL 3 BYTES CHECKED
0665 FAD4 6C 00 00              JMP   (LOC0)                   ; GO BOOT... 
0666 FAD7
0667 FAD7              REGDSP   EQU   *                        ;Maintained entry point $FAD7
0668 FAD7 A0 A5                 LDY   #$A5                     ;Go do new 65816 register display
0669 FAD9 80 1F                 BRA   NODISK1                  ;
0670 FADB
0671 FADB              NOFIX    EQU   *
0672 FADB 20 D2 F9              JSR   WARMUPAPTALK             ;Wrmstrt Aptalk/Enable ints for DskAcc Mgr
0673 FADE 6C F2 03              JMP   (SOFTEV)                 ;Continue through soft entry vector
0674 FAE1
0675 FAE1              WHO2BOOT EQU   *
0676 FAE1 AF E8 02 E1           LDA   >USERSLTST               ;What is user's startup slot preference?
0677 FAE5 F0 0D                 BEQ   SCAN2BOOT                ;=0 then scan to boot
0678 FAE7 C9 08                 CMP   #$8                      ;8=RAMdisk 9=ROMdisk A=AppleTalk   
0679 FAE9 90 04                 BCC   WHO2BOOT2                ;<8 then boot from specific slot
0680 FAEB 80 37                 BRA   MAYBEAPTALK              ;>8 then may be AppleTalk  
0681 FAED              BOOTSMART EQU   *
0682 FAED A9 05                 LDA   #$5                      ;Force smart prt if RAMDISK/ROMDISK picked
0683 FAEF              WHO2BOOT2 EQU   *
0684 FAEF 09 C0                 ORA   #$C0                     ;Make hi byte of jump instruction
0685 FAF1 1A                    INC   A                        ;Offset for normal monitor search routine
0686 FAF2 80 C2                 BRA   SETPLP2                  ;Return to normal boot routine
0687 FAF4
0688 FAF4              SCAN2BOOT EQU   *                       ;Do normal scan to boot.
0689 FAF4 A9 C8                 LDA   #$C8                     ;For SCAN as choice load hi slot+1
0690 FAF6 80 BE                 BRA   SETPLP2                  ;Return to normal boot routine
0691 FAF8
0692 FAF8              NODISK   EQU   *
0693 FAF8 A0 98                 LDY   #$98                     ;'Y'=$98 for no disk on power up msg
0694 FAFA              NODISK1  EQU   *
0695 FAFA 4C 9C F8              JMP   GOTOBANKFF               ;Go do routine in bank FF
0696 FAFD
0697 FAFD                       FillTo $FAFD                   ;Pad
0698 FAFD
0699 FAFD 59 FA        PWRCON   DC W:OLDBRK
0700 FAFF
0701 FAFF              * Warning: $00 'MUST' appear at $FAFF
0702 FAFF
0703 FAFF 00 E0 45              DC B:$00,$E0,$45               ;Maintained entry point $FAFF
0704 FB02 20 FF 00 FF  DISKID   DC B:$20,$FF,$00,$FF
0705 FB06 03 FF 3C              DC B:$03,$FF,$3C
0706 FB09
0707 FB09              APPLEMSG EQU   *                        ;Maintained entry point $FB09
0708 FB09 C1 F0 F0 EC           DC B:'Apple ]['
0709 FB11              XLTBL    EQU   *
0710 FB11 C4 C2 C1              DC B:$C4,$C2,$C1               ;For 'ESC' keypress conversion
0711 FB14 FF C3                 DC B:$FF,$C3                   ;
0712 FB16 FF FF CD              DC B:$FF,$FF,$CD               ;
0713 FB19
0714 FB19              RTBL     EQU   *                        ;Maintained entry point $FB19
0715 FB19 C1 D8 D9              DC B:$C1,$D8,$D9               ;'AXYPS'
0716 FB1C D0 D3                 DC B:$D0,$D3                   ;
0717 FB1E              PREAD    EQU   *                        ;Maintained entry point $FB1E
0718 FB1E 4C EB FB              JMP   DOPREAD                  ;Y=$95 for PREAD (Save 'X' through here)
0719 FB21              PREAD4   EQU   *                        ;Maintained entry point $FB21
0720 FB21 4C E6 FB              JMP   DOPREAD4                 ;Timeout then do PREAD
0721 FB24
0722 FB24
0723 FB24
0724 FB24                       TITLE 'Auto-Start Monitor ROM'
0725 FB24              *****************************************
0726 FB24              *                                       *
0727 FB24              *               APPLE II                *
0728 FB24              *              MONITOR II               *
0729 FB24              *                                       *
0730 FB24              *    Copyright 1978, 1981, 1984-1989    *
0731 FB24              *                   by                  *
0732 FB24              *          Apple Computer, Inc.         *
0733 FB24              *                                       *
0734 FB24              *          All Rights Reserved          *
0735 FB24              *                                       *
0736 FB24              *       S. Wozniak             1977     *
0737 FB24              *       A. Baum                1977     *
0738 FB24              *       John A            Nov  1978     *
0739 FB24              *       R. Auricchio      Sep  1981     *
0740 FB24              *       E. Beernink            1984     *
0741 FB24              *       E.K. Lai          Sep  1984     *
0742 FB24              *       F. Bachman          1985-1987   *
0743 FB24              *       Joe Bo              1988-1989   *
0744 FB24              *                                       *
0745 FB24              *****************************************
0746 FB24
0747 FB24
0748 FB24              MAYBEAPTALK EQU   *
0749 FB24 C9 0A                 CMP   #$0A                     ;Check to boot from AppleTalk
0750 FB26 D0 C5                 BNE   BOOTSMART                ;Boot smartport if RAMDISK/ROMDISK picked
0751 FB28 4C 20 F9              JMP   TRYAPTALK                ;Try AppleTalk
0752 FB2B
0753 FB2B              DOFFSVK  EQU   *                        ;Called from bank FF to set video/keyboard
0754 FB2B 4C F3 A9              JMP   SETVIDKBDFF              ;Do it via reverse dispatcher
0755 FB2E
0756 FB2E
0757 FB2E                       FillTO $FB2F                   ;Pad
0758 FB2F
0759 FB2F              INIT     EQU   *                        ;Maintained entry point $FB2F
0760 FB2F A9 00                 LDA   #$00                     ;
0761 FB31 85 48                 STA   STATUS                   ;CLR STATUS FOR DEBUG SOFTWARE 
0762 FB33 AD 56 C0              LDA   LORES
0763 FB36 AD 54 C0              LDA   TXTPAGE1                 ;INIT VIDEO MODE 
0764 FB39              SETTXT   EQU   *                        ;Maintained entry point $FB39
0765 FB39 AD 51 C0              LDA   TXTSET                   ;SET FOR TEXT MODE 
0766 FB3C A9 00                 LDA   #$00                     ;FULL SCREEN WINDOW 
0767 FB3E F0 0B                 BEQ   SETWND
0768 FB40              SETGR    EQU   *                        ;Maintained entry point $FB40
0769 FB40 AD 50 C0              LDA   TXTCLR                   ;SET FOR GRAPHICS MODE 
0770 FB43 AD 53 C0              LDA   MIXSET                   ;LOWER 4 LINES AS TEXT WINDOW 
0771 FB46 20 36 F8              JSR   CLRTOP
0772 FB49 A9 14                 LDA   #$14
0773 FB4B              SETWND   EQU   *                        ;Maintained entry point $FB4B
0774 FB4B 85 22                 STA   WNDTOP                   ;SET FOR 40 COL WINDOW 
0775 FB4D A9 00                 LDA   #$00                     ;Left side of screen starts at $00
0776 FB4F 85 20                 STA   WNDLFT                   ;Top in A-reg, bottom at line $24
0777 FB51              SETWND2  EQU   *                        ;Maintained entry point $FB51
0778 FB51 A0 0C                 LDY   #$C                      ;CODE=SETWND 
0779 FB53 80 A5                 BRA   NODISK1                  ;
0780 FB55
0781 FB55
0782 FB55              * Identification bytes for CORTLAND
0783 FB55              *
0784 FB55              * REGIDz's are return'ed when the user JSR's to $FE1F.
0785 FB55              *
0786 FB55              * REGIDA = Bit 15 = reserved
0787 FB55              *          Bit 14 = reserved
0788 FB55              *          Bit 13 = reserved
0789 FB55              *          Bit 12 = reserved
0790 FB55              *          Bit 11 = reserved
0791 FB55              *          Bit 10 = reserved
0792 FB55              *          Bit 09 = reserved
0793 FB55              *          Bit 08 = reserved
0794 FB55              *          Bit 07 = reserved
0795 FB55              *          Bit 06 = 1 if system has a memory expansion slot
0796 FB55              *          Bit 05 = 1 if system has an IWM port
0797 FB55              *          Bit 04 = 1 if system has a built in clock
0798 FB55              *          Bit 03 = 1 if system has front desk bus
0799 FB55              *          Bit 02 = 1 if system has SCC built in
0800 FB55              *          Bit 01 = 1 if system has external slots
0801 FB55              *          Bit 00 = 1 if system has internal slots
0802 FB55              *
0803 FB55              * REGIDX = Bit 15 = reserved
0804 FB55              *          Bit 14 = reserved
0805 FB55              *          Bit 13 = reserved
0806 FB55              *          Bit 12 = reserved
0807 FB55              *          Bit 11 = reserved
0808 FB55              *          Bit 10 = reserved
0809 FB55              *          Bit 09 = reserved
0810 FB55              *          Bit 08 = reserved
0811 FB55              *          Bit 07 = reserved
0812 FB55              *          Bit 06 = reserved
0813 FB55              *          Bit 05 = reserved
0814 FB55              *          Bit 04 = reserved
0815 FB55              *          Bit 03 = reserved
0816 FB55              *          Bit 02 = reserved
0817 FB55              *          Bit 01 = reserved
0818 FB55              *          Bit 00 = reserved
0819 FB55              *
0820 FB55              * REGIDY = Bit 15-8 = machine id byte
0821 FB55              *                  0 = Cortland
0822 FB55              *                  01-FF = future systems
0823 FB55              *          Bit 07 = 0
0824 FB55              *          Bit 06 = 0
0825 FB55              *          Bit 05 = 0
0826 FB55              *          Bit 04 = 0         Bits 00-07 = ROM version number
0827 FB55              *          Bit 03 = 0
0828 FB55              *          Bit 02 = 0
0829 FB55              *          Bit 01 = 0
0830 FB55              *          Bit 00 = 1   
0831 FB55
0832 FB55 7F 00        REGIDA   DC W:$007F                     ;Register identification byte
0833 FB57 00 00        REGIDX   DC W:$0000                     ;Register identification byte
0834 FB59 03 00        REGIDY   DC W:$0003                     ;Register identification byte 
0835 FB5B
0836 FB5B
0837 FB5B                       FillTo $FB5B                   ;Pad
0838 FB5B
0839 FB5B              TABV     EQU   *                        ;Maintained entry point $FB5B
0840 FB5B 85 25                 STA   CV                       ;VTABS TO ROW IN A-REG 
0841 FB5D 4C 22 FC              JMP   VTAB
0842 FB60
0843 FB60              APPLEII  EQU   *                        ;Maintained entry point $FB60
0844 FB60 20 58 FC              JSR   HOME                     ;CLEAR THE SCRN 
0845 FB63 A0 A8                 LDY   #$A8                     ;'Y'=$A8 for Apple IIgs msg
0846 FB65 80 93                 BRA   NODISK1                  ;Continue this way
0847 FB67
0848 FB67
0849 FB67                                                      ; SEG $FF
0850 FB67              MCOFFSET EQU   *                        ;Mouse card offset to id bytes
0851 FB67 05 07 0B FB           DC B:$05,$07,$0B,$FB
0852 FB6B
0853 FB6B              MIDVALUE EQU   *                        ;Mouse card id bytes
0854 FB6B 38 18 01 D6           DC B:$38,$18,$01,$D6
0855 FB6F                                                      ; SEG $00
0856 FB6F
0857 FB6F
0858 FB6F                       FillTo $FB6F                   ;Pad
0859 FB6F
0860 FB6F              SETPWRC  EQU   *                        ;Maintained entry point $FB6F
0861 FB6F AD F3 03              LDA   SOFTEV+1                 ;ROUTINE TO CALCULATE THE 'FUNNY  
0862 FB72 49 A5                 EOR   #$A5                     ;COMPLEMENT' FOR THE RESET VECTOR 
0863 FB74 8D F4 03              STA   PWREDUP
0864 FB77 60                    RTS   
0865 FB78
0866 FB78              * CHECK FOR A PAUSE (CONTROL-S). 
0867 FB78
0868 FB78              VIDWAIT  EQU   *                        ;Maintained entry point $FB78
0869 FB78 C9 8D                 CMP   #$8D                     ;ONLY WHEN I HAVE A CR
0870 FB7A D0 18                 BNE   NOWAIT                   ;NOT SO, DO REGULAR
0871 FB7C AC 00 C0              LDY   KBD                      ;IS KEY PRESSED?
0872 FB7F 10 13                 BPL   NOWAIT                   ;NO. 
0873 FB81 C0 93                 CPY   #$93                     ;YES -- IS IT CTRL-S?
0874 FB83 D0 0F                 BNE   NOWAIT                   ;NOPE - IGNORE
0875 FB85 2C 10 C0              BIT   KBDSTRB                  ;CLEAR STROBE
0876 FB88              KBDWAIT  EQU   *                        ;Maintained entry point $FB88
0877 FB88 AC 00 C0              LDY   KBD                      ;WAIT TILL NEXT KEY TO RESUME
0878 FB8B 10 FB                 BPL   KBDWAIT                  ;WAIT FOR KEYPRESS
0879 FB8D C0 83                 CPY   #$83                     ;IS IT CONTROL-C?
0880 FB8F F0 03                 BEQ   NOWAIT                   ;YES, SO LEAVE IT
0881 FB91 2C 10 C0              BIT   KBDSTRB                  ;CLR STROBE
0882 FB94 80 67        NOWAIT   BRA   VIDOUT                   ;DO AS BEFORE
0883 FB96
0884 FB96 A8           ESCNOW   TAY                            ;USE CHAR AS INDEX
0885 FB97 B9 48 FA              LDA   XLTBL-$C9,Y              ;TRANSLATE IJKM TO CBAD
0886 FB9A 20 AC FB              JSR   ESCOLD                   ;DO THE CURSOR MOTION
0887 FB9D 20 02 FD              JSR   RDESC                    ;GET IJKM, ijkm, ARROWS
0888 FBA0 C9 CE        ESCNEW   CMP   #$CE                     ;IS THIS AN 'N'? 
0889 FBA2 B0 08                 BCS   ESCOLD                   ;'N' OR GREATER - DO IT! 
0890 FBA4 C9 C9                 CMP   #$C9                     ;LESS THAN 'I'?
0891 FBA6 90 04                 BCC   ESCOLD                   ;YES, SO DO OLD WAY
0892 FBA8 C9 CC                 CMP   #$CC                     ;IS IT AN 'L'?
0893 FBAA D0 EA                 BNE   ESCNOW                   ;GO DO IT
0894 FBAC              ESCOLD   EQU   *
0895 FBAC C9 B8                 CMP   #'8'                     ;Does user want to go to 80 column mode
0896 FBAE 38                    SEC                            ;INSURE CARRY SET
0897 FBAF D0 7B                 BNE   ESC1_2                   ;<> = then do regular 'ESC' key tests
0898 FBB1 80 01                 BRA   ESC1
0899 FBB3
0900 FBB3                       FillTo $FBB3                   ;Pad
0901 FBB3
0902 FBB3              VERSION  EQU   *                        ;Maintained entry point $FBB3
0903 FBB3 06                    DC B:$06                       ;FOR IDCHECK
0904 FBB4
0905 FBB4              ESC1     EQU   *
0906 FBB4 20 2C FA              JSR   T480CARD2                ;Test for 80 column card before enabling
0907 FBB7 D0 73                 BNE   ESC1_2                   ;<>= then do regular 'ESC' key tests
0908 FBB9 20 90 FC              JSR   TSTCTL3                  ;
0909 FBBC 4C EF FE              JMP   ESC1_1                   ;Continue this way
0910 FBBF
0911 FBBF                       FillTo $FBBF                   ;Pad
0912 FBBF
0913 FBBF              ZIDBYTE2 EQU   *                        ;Maintained entry point $FBBF
0914 FBBF 00                    DC B:$00                       ;ROM rev ID byte
0915 FBC0              ZIDBYTE  EQU   *                        ;Maintained entry point $FBC0
0916 FBC0 E0                    DC B:$E0                       ;//e ROM ID byte - Maintained
0917 FBC1
0918 FBC1              BASCALC  EQU   *                        ;Maintained entry point $FBC1
0919 FBC1 48                    PHA                            ;CALC BASE ADDR IN BASL,H
0920 FBC2 4A                    LSR   A                        ;FOR GIVEN LINE NO.
0921 FBC3 29 03                 AND   #$03                     ; 0<=LINE NO.<=$17
0922 FBC5 09 04                 ORA   #$04                     ;ARG = 000ABCDE, GENERATE
0923 FBC7 85 29                 STA   BASH                     ; BASH = 000001CD
0924 FBC9 68                    PLA                            ; AND
0925 FBCA 29 18                 AND   #$18                     ; BASL = EABAB000
0926 FBCC 90 02                 BCC   @1
0927 FBCE 69 7F                 ADC   #$7F
0928 FBD0 85 28        @1       STA   BASL
0929 FBD2 0A                    ASL   A
0930 FBD3 0A                    ASL   A
0931 FBD4 05 28                 ORA   BASL                     ;Must do this way since some programs
0932 FBD6 85 28                 STA   BASL                     ; depend on BASL being in 'A' on exit.
0933 FBD8 60                    RTS   
0934 FBD9
0935 FBD9              CHKBELL  EQU   *
0936 FBD9 C9 87                 CMP   #$87                     ;BELL CHAR? (CONTROL-G) 
0937 FBDB D0 1F                 BNE   RTS3                     ; NO, RETURN. 
0938 FBDD
0939 FBDD              BELL1    EQU   *                        ;Maintained entry point $FBDD
0940 FBDD A0 9E                 LDY   #$9E                     ;'Y'=$9E for NEWBELL1 routine
0941 FBDF 80 48                 BRA   GOTOFF                   ;Off to bank FF to execute
0942 FBE1
0943 FBE1 EA                    NOP                            ;Required for entry point alignment
0944 FBE2
0945 FBE2              BELL1_2  EQU   *                        ;Maintained entry point $FBE2
0946 FBE2 80 F9                 BRA   BELL1                    ;Skip behind
0947 FBE4
0948 FBE4              BELL2    EQU   *                        ;Maintained entry point $FBE4
0949 FBE4 80 F7                 BRA   BELL1                    ;Skip behind
0950 FBE6
0951 FBE6              DOPREAD4 EQU   *                        ;Entry here means time out the do PREAD
0952 FBE6 BD 64 C0              LDA   PADDL0,X                 ;Read paddle til value is '-'
0953 FBE9 10 FB                 BPL   DOPREAD4                 ;
0954 FBEB
0955 FBEB              DOPREAD  EQU   *
0956 FBEB A0 95                 LDY   #$95                     ;'Y'=$95 for new paddle read routine
0957 FBED 80 3A                 BRA   GOTOFF                   ;(Save 'X' through PREAD routine)
0958 FBEF
0959 FBEF                       FillTo $FBF0                   ;Pad
0960 FBF0
0961 FBF0              STORADV  EQU   *                        ;Maintained entry point $FBF0
0962 FBF0 A4 24                 LDY   CH                       ;CURSOR H INDEX TO Y-REG 
0963 FBF2 91 28                 STA   (BASL),Y                 ;STORE CHAR IN LINE 
0964 FBF4              ADVANCE  EQU   *                        ;Maintained entry point $FBF4
0965 FBF4 E6 24                 INC   CH                       ;INCREMENT CURSOR H INDEX 
0966 FBF6 A5 24                 LDA   CH                       ; (MOVE RIGHT) 
0967 FBF8 C5 21                 CMP   WNDWDTH                  ;BEYOND WINDOW WIDTH? 
0968 FBFA B0 66                 BCS   CR                       ; YES, CR TO NEXT LINE. 
0969 FBFC 60           RTS3     RTS                            ; NO, RETURN. 
0970 FBFD
0971 FBFD              VIDOUT   EQU   *                        ;Maintained entry point $FBFD
0972 FBFD 80 5D                 BRA   TSTFORCUR                ;Test for new cursor
0973 FBFF
0974 FBFF              VIDOUT2  EQU   *
0975 FBFF B0 EF                 BCS   STORADV                  ; NO, OUTPUT IT. 
0976 FC01 A8                    TAY                            ;INVERSE VIDEO? 
0977 FC02 10 EC                 BPL   STORADV                  ; YES, OUTPUT IT. 
0978 FC04 C9 8D                 CMP   #$8D                     ;CR? 
0979 FC06 F0 5A                 BEQ   CR                       ; YES. 
0980 FC08 C9 8A                 CMP   #$8A                     ;LINE FEED? 
0981 FC0A F0 5A                 BEQ   LF                       ; IF SO, DO IT. 
0982 FC0C C9 88                 CMP   #$88                     ;BACK SPACE? (CONTROL-H) 
0983 FC0E D0 75                 BNE   TSTCTL                   ;No then test for control-^
0984 FC10              BS       EQU   *                        ;Maintained entry point $FC10
0985 FC10 5A                    PHY                            ;Save original 'Y'
0986 FC11 A0 9B                 LDY   #$9B                     ;Decrement all cursors
0987 FC13 20 9C F8              JSR   GOTOBANKFF               ;Do it in bank FF
0988 FC16 30 63                 BMI   BS2                      ;Continue with BS this way
0989 FC18 7A                    PLY                            ;Restore original 'Y' value
0990 FC19 60                    RTS                            ;Back to original caller
0991 FC1A
0992 FC1A              UP       EQU   *                        ;Maintained entry point $FC1A
0993 FC1A A5 22                 LDA   WNDTOP                   ;CURSOR V INDEX 
0994 FC1C C5 25                 CMP   CV
0995 FC1E B0 DC                 BCS   RTS3                     ;IF TOP LINE THEN RETURN 
0996 FC20 C6 25                 DEC   CV                       ;DECR CURSOR V INDEX 
0997 FC22
0998 FC22              VTAB     EQU   *                        ;Maintained entry point $FC22
0999 FC22 A5 25                 LDA   CV                       ;GET CURSOR V INDEX 
1000 FC24              VTABZ    EQU   *                        ;Maintained entry point $FC24
1001 FC24 85 28                 STA   BASL                     ;temporarily save Acc
1002 FC26 98                    TYA                            ;and Y
1003 FC27 A0 04                 LDY   #$4                      ;this is VTABZ call
1004 FC29 4C 9C F8     GOTOFF   JMP   GOTOBANKFF               ;=> always perform call
1005 FC2C
1006 FC2C 49 C0        ESC1_2   EOR   #$C0                     ;ESC '@'? 
1007 FC2E F0 28                 BEQ   HOME                     ; IF SO DO HOME AND CLEAR
1008 FC30 69 FD                 ADC   #$FD                     ;ESC-A OR B CHECK
1009 FC32 90 C0                 BCC   ADVANCE                  ; A, ADVANCE
1010 FC34 F0 DA                 BEQ   BS                       ; B, BACKSPACE
1011 FC36 69 FD                 ADC   #$FD                     ;ESC-C OR D CHECK
1012 FC38 90 2C                 BCC   LF                       ; C, DOWN
1013 FC3A F0 DE                 BEQ   UP                       ; D, GO UP 
1014 FC3C 69 FD                 ADC   #$FD                     ;ESC-E OR F CKECK
1015 FC3E 90 5C                 BCC   CLREOL                   ; E, CLEAR TO END OF LINE
1016 FC40 D0 BA                 BNE   RTS3                     ; ELSE NOT F,RETURN
1017 FC42
1018 FC42              CLREOP   EQU   *                        ;Maintained entry point $FC42
1019 FC42 A0 0A                 LDY   #$A                      ;CODE=CLREOP
1020 FC44 D0 E3                 BNE   GOTOFF                   ;DO 40/80 
1021 FC46
1022 FC46 2C 1F C0     NEWVW    BIT   RD80VID                  ;in 80 columns?
1023 FC49 10 04                 BPL   @1                       ;=>not 80 columns
1024 FC4B A0 00                 LDY   #$0                      ;Print a character
1025 FC4D 80 DA                 BRA   GOTOFF                   ;through video firmware
1026 FC4F
1027 FC4F 98           @1       TYA                            ;get masked character
1028 FC50 48                    PHA                            ;and set up for vidwait
1029 FC51 20 78 FB              JSR   VIDWAIT                  ;print the character
1030 FC54 68                    PLA                            ;restore Acc
1031 FC55 A4 35                 LDY   YSAV1                    ;and Y
1032 FC57 60                    RTS   
1033 FC58
1034 FC58              HOME     EQU   *                        ;Maintained entry point $FC58
1035 FC58 A0 05                 LDY   #5                       ;CODE=HOME
1036 FC5A 80 CD                 BRA   GOTOFF                   ;do 40/80
1037 FC5C
1038 FC5C              TSTFORCUR EQU   *
1039 FC5C EB                    XBA                            ;Save 'A'
1040 FC5D 4C EB FC              JMP   TSTFORCUR2               ;Continue this way
1041 FC60
1042 FC60                       FillTo $FC62                   ;Pad
1043 FC62
1044 FC62              CR       EQU   *                        ;Maintained entry point $FC62
1045 FC62 A9 00                 LDA   #$00                     ;CURSOR TO LEFT OF INDEX 
1046 FC64 85 24                 STA   CH                       ;(RET CURSOR H=0) 
1047 FC66              LF       EQU   *                        ;Maintained entry point $FC66
1048 FC66 E6 25                 INC   CV                       ;INCR CURSOR V. (DOWN 1 LINE) 
1049 FC68 A5 25                 LDA   CV
1050 FC6A C5 23                 CMP   WNDBTM                   ;OFF SCREEN? 
1051 FC6C 90 B6                 BCC   VTABZ                    ;  NO, SET BASE ADDR 
1052 FC6E C6 25                 DEC   CV                       ;DECR CURSOR V. (BACK TO BOTTOM) 
1053 FC70
1054 FC70              SCROLL   EQU   *                        ;Maintained entry point $FC70
1055 FC70 A0 06                 LDY   #6                       ;CODE=SCROLL
1056 FC72 80 B5                 BRA   GOTOFF                   ;DO 40/80 
1057 FC74
1058 FC74 90 02        DOCOUT1  BCC   @1                       ;don't mask controls
1059 FC76 25 32                 AND   INVFLG                   ;apply inverse mask
1060 FC78 4C F7 FD     @1       JMP   COUTZ1                   ;go back to COUT1
1061 FC7B
1062 FC7B              BS2      EQU   *                        ;Continuation of BS routine
1063 FC7B A5 21                 LDA   WNDWDTH                  ;'A' value for WDTHFF routine
1064 FC7D A0 9C                 LDY   #$9C                     ;'Y' = $9C for WDTHFF routine
1065 FC7F 20 9C F8              JSR   GOTOBANKFF               ;Go do it
1066 FC82 7A                    PLY                            ;Recall original 'Y' value
1067 FC83 80 95                 BRA   UP                       ;Go to UP routine to continue
1068 FC85
1069 FC85              TSTCTL   EQU   *                        ;Test for control-^ input
1070 FC85 C9 9E                 CMP   #$9E                     ;If control-^ then change cursor
1071 FC87 F0 03                 BEQ   @1                       ;
1072 FC89 4C D9 FB              JMP   CHKBELL                  ;If not control-^ then maybe bell?
1073 FC8C
1074 FC8C              @1       EQU   *
1075 FC8C A9 81                 LDA   #$81                     ;Set change cursor flag bit
1076 FC8E 80 02                 BRA   TSTCTL4                  ;
1077 FC90
1078 FC90              TSTCTL3  EQU   *
1079 FC90 A9 40                 LDA   #$40                     ;Set change to 80 columns flag
1080 FC92              TSTCTL4  EQU   *
1081 FC92 8F 37 01 E1           STA   >CHGCURFLG               ;
1082 FC96 60                    RTS                            ;Back to caller with flag set
1083 FC97
1084 FC97              INSDS1   EQU   *
1085 FC97 A0 97                 LDY   #$97                     ;Y=$97 for XINSDS1 in bank FF
1086 FC99              GOTOFF2  EQU   *
1087 FC99 80 8E                 BRA   GOTOFF                   ;Go do routine
1088 FC9B
1089 FC9B                       FillTo $FC9C                   ;Pad
1090 FC9C
1091 FC9C              * Note: bytes CLREOL and CLREOLZ ($38 and $18)
1092 FC9C              * are used by slot test in TSTROM.
1093 FC9C
1094 FC9C              CLREOL   EQU   *                        ;Maintained entry point $FC9C
1095 FC9C 38                    SEC                            ;say it is EOL
1096 FC9D 90                    OPCODE BCC                     ;
1097 FC9E              CLREOLZ  EQU   *                        ;Maintained entry point $FC9E
1098 FC9E 18                    CLC                            ;say it is EOLZ
1099 FC9F 84 2A                 STY   BAS2L                    ;save Y in temp
1100 FCA1 A0 07                 LDY   #7                       ;code=CLREOL
1101 FCA3 B0 84                 BCS   GOTOFF                   ;do it
1102 FCA5 C8                    INY                            ;code 8=CLREOLZ
1103 FCA6 80 81                 BRA   GOTOFF
1104 FCA8
1105 FCA8              WAIT     EQU   *                        ;Maintained entry point $FCA8
1106 FCA8 48                    PHA                            ;Save wait value
1107 FCA9 AD 36 C0              LDA   CYAREG                   ;Switch to slow speed
1108 FCAC EB                    XBA                            ;Save user speed in 'B'
1109 FCAD A9 80                 LDA   #$80                     ;Reset bit 7 only
1110 FCAF 1C 36 C0              TRB   CYAREG                   ;Force slow speed
1111 FCB2 80 25                 BRA   WAITNEW1                 ;Go do speed sensitive routine
1112 FCB4
1113 FCB4                       FillTo $FCB4                   ;Pad
1114 FCB4
1115 FCB4              NXTA4    EQU   *                        ;Maintained entry point $FCB4
1116 FCB4 E6 42                 INC   A4L                      ;INCR 2-BYTE A4 
1117 FCB6 D0 02                 BNE   NXTA1                    ; AND A1 
1118 FCB8 E6 43                 INC   A4H
1119 FCBA              NXTA1    EQU   *                        ;Maintained entry point $FCBA
1120 FCBA A5 3C                 LDA   A1L                      ;INCR 2-BYTE A1. 
1121 FCBC C5 3E                 CMP   A2L                      ; AND COMPARE TO A2 
1122 FCBE A5 3D                 LDA   A1H                      ; (CARRY SET IF >=) 
1123 FCC0 E5 3F                 SBC   A2H
1124 FCC2 E6 3C                 INC   A1L
1125 FCC4 D0 02                 BNE   RTS4B
1126 FCC6 E6 3D                 INC   A1H
1127 FCC8 60           RTS4B    RTS   
1128 FCC9
1129 FCC9
1130 FCC9                       TITLE 'Auto-Start Monitor ROM'
1131 FCC9              *****************************************
1132 FCC9              *                                       *
1133 FCC9              *               APPLE II                *
1134 FCC9              *              MONITOR II               *
1135 FCC9              *                                       *
1136 FCC9              *    Copyright 1978, 1981, 1984-1989    *
1137 FCC9              *                   by                  *
1138 FCC9              *          Apple Computer, Inc.         *
1139 FCC9              *                                       *
1140 FCC9              *          All Rights Reserved          *
1141 FCC9              *                                       *
1142 FCC9              *       S. Wozniak             1977     *
1143 FCC9              *       A. Baum                1977     *
1144 FCC9              *       John A            Nov  1978     *
1145 FCC9              *       R. Auricchio      Sep  1981     *
1146 FCC9              *       E. Beernink            1984     *
1147 FCC9              *       E.K. Lai          Sep  1984     *
1148 FCC9              *       F. Bachman          1985-1987   *
1149 FCC9              *       Joe Bo              1988-1989   *
1150 FCC9              *                                       *
1151 FCC9              *****************************************
1152 FCC9
1153 FCC9
1154 FCC9              HEADR    EQU   *                        ;Maintained entry point $FCC9
1155 FCC9 60                    RTS                            ;Dummy routine
1156 FCCA
1157 FCCA B9 00 02     UPMON    LDA   IN,Y                     ;get character
1158 FCCD C8                    INY                            ;point to next char
1159 FCCE C9 E1                 CMP   #$E1                     ;is it lowercase?
1160 FCD0 90 06                 BCC   @1                       ;=>nope
1161 FCD2 C9 FB                 CMP   #$FB                     ;lowercase?
1162 FCD4 B0 02                 BCS   @1                       ;=>nope
1163 FCD6 29 DF                 AND   #$DF                     ;else upshift
1164 FCD8 60           @1       RTS   
1165 FCD9
1166 FCD9              WAITNEW1 EQU   *
1167 FCD9 68                    PLA                            ;Restore wait value
1168 FCDA 38                    SEC                            ;Enter with count in A
1169 FCDB              @1       EQU   *
1170 FCDB 48                    PHA                            ;Delay is:
1171 FCDC              @2       EQU   *
1172 FCDC E9 01                 SBC   #$01                     ;
1173 FCDE D0 FC                 BNE   @2                       ;13+11*A+5*A*A
1174 FCE0 68                    PLA                            ;@ 1.023 usec/cycle
1175 FCE1 E9 01                 SBC   #$01                     ;
1176 FCE3 D0 F6                 BNE   @1                       ;
1177 FCE5 EB                    XBA                            ;Recall user speed/make 'B'=$00
1178 FCE6 8D 36 C0              STA   CYAREG                   ;Restore user speed
1179 FCE9 EB                    XBA                            ;WAIT always exits with 'A'=0/'c'=1
1180 FCEA 60                    RTS                            ;Exit to caller
1181 FCEB
1182 FCEB
1183 FCEB              TSTFORCUR2 EQU   *
1184 FCEB AF 37 01 E1           LDA   >CHGCURFLG               ;'-' then change cursor
1185 FCEF 0A                    ASL   A                        ;'c'=change cursor 'n'=go to 80 columns
1186 FCF0 30 20                 BMI   TSTFORCUR4               ;<>= then it's time to go to 80 columns
1187 FCF2 EB                    XBA                            ;New cursor
1188 FCF3 90 08                 BCC   TSTFORCUR6               ;
1189 FCF5 8F 35 01 E1           STA   >CURSOR                  ;
1190 FCF9              TSTFORCUR3 EQU   *
1191 FCF9 A9 01                 LDA   #$01                     ;Reset change cursor flag
1192 FCFB 80 95                 BRA   TSTCTL4                  ;Go reset it
1193 FCFD
1194 FCFD              TSTFORCUR6 EQU   *
1195 FCFD C9 A0                 CMP   #$A0                     ;Test against space for control characters
1196 FCFF 4C FF FB              JMP   VIDOUT2                  ;Back to normal routines
1197 FD02
1198 FD02
1199 FD02                       FillTo $FD02                   ;Pad
1200 FD02
1201 FD02              RDESC    EQU   *
1202 FD02 20 0C FD              JSR   RDKEY                    ;GET A KEY
1203 FD05 A0 01                 LDY   #1                       ;CODE=FIXIT
1204 FD07              TOGOTOFF2 EQU   *
1205 FD07 80 90                 BRA   GOTOFF2                  ;=>always 
1206 FD09
1207 FD09              * Flag to the video firmware that escapes are allowed.
1208 FD09              * This routine is called by RDCHAR which is called by 
1209 FD09              * GETLN.  The high bit of MSLOT is set by all cards  
1210 FD09              * that use the C800 space.       
1211 FD09
1212 FD09 4E F8 07     NEWRDKEY LSR   MSLOT                    ;<128 means escape allowed
1213 FD0C
1214 FD0C              RDKEY    EQU   *                        ;Maintained entry point $FD0C
1215 FD0C A0 0B                 LDY   #$B                      ;Display old Apple ][ inverse cursor
1216 FD0E D0 0F                 BNE   RDKEY0                   ;NEVER change this call
1217 FD10              FD10     EQU   *                        ;Maintained entry point $FD10
1218 FD10 80 06                 BRA   RDKEY1                   ;Input via input hooks
1219 FD12
1220 FD12              TSTFORCUR4 EQU   *
1221 FD12 A0 A2                 LDY   #$A2                     ;'Y'=$A2 to enter 80 columns
1222 FD14 80 83                 BRA   GOTOFF2                  ;Do it in bank FF
1223 FD16
1224 FD16                       FillTo $FD18                   ;Pad
1225 FD18
1226 FD18              RDKEY1   EQU   *                        ;Maintained entry point $FD18
1227 FD18 6C 38 00              JMP   (KSWL)                   ;Input via input hooks
1228 FD1B
1229 FD1B              KEYIN    EQU   *                        ;Maintained entry point $FD1B
1230 FD1B A0 03                 LDY   #3                       ;RDKEY 
1231 FD1D 80 E8                 BRA   TOGOTOFF2                ;
1232 FD1F
1233 FD1F              RDKEY0   EQU   *
1234 FD1F 20 9C F8              JSR   GOTOBANKFF               ;Go to it
1235 FD22 80 EC                 BRA   FD10                     ;Continue through input hooks
1236 FD24
1237 FD24              NOTCR2   EQU   *
1238 FD24 20 78 F9              JSR   NOTCR3                   ;Go test for ignore character or not
1239 FD27 B0 4C                 BCS   NXTCHAR                  ;If 'c'=1 then ignore key pressed
1240 FD29 C9 88                 CMP   #$88                     ;Test for backspace
1241 FD2B 80 25                 BRA   NOTCR4                   ;
1242 FD2D
1243 FD2D                       FillTo $FD2F                   ;Pad
1244 FD2F
1245 FD2F 20 02 FD     ESC      JSR   RDESC                    ;
1246 FD32 20 A0 FB              JSR   ESCNEW                   ;HANDLE ESC FUNCTION. 
1247 FD35              RDCHAR   EQU   *                        ;Maintained entry point $FD35
1248 FD35 20 09 FD              JSR   NEWRDKEY                 ;Flag RDCHAR and read key 
1249 FD38 C9 9B                 CMP   #$9B                     ;'ESC'? 
1250 FD3A F0 F3                 BEQ   ESC                      ;  YES, DON'T RETURN. 
1251 FD3C 60                    RTS   
1252 FD3D
1253 FD3D              * Go to user interrupt handler(s).
1254 FD3D
1255 FD3D              GOIRQ~Bnk00 EQU   *-Rel~Org+Bnk~Org
1256 FD3D 6C FE 03              JMP   (IRQLOC)                 ;and jump to user
1257 FD40
1258 FD40 A0 0D        PICKFIX  LDY   #$D                      ;code = fixpick
1259 FD42 20 9C F8              JSR   GOTOBANKFF               ;do 80 column pick
1260 FD45 A4 24                 LDY   CH                       ;restore Y
1261 FD47 9D 00 02              STA   IN,X                     ;and save new character
1262 FD4A
1263 FD4A              NOTCR    EQU   *
1264 FD4A 20 ED FD              JSR   COUT                     ;echo typed char
1265 FD4D BD 00 02              LDA   IN,X
1266 FD50 80 D2                 BRA   NOTCR2                   ;Check for cursor change indicator
1267 FD52
1268 FD52              NOTCR4   EQU   *
1269 FD52 F0 1D                 BEQ   BCKSPC                   ;  - BACKSPACE 
1270 FD54 C9 98                 CMP   #$98
1271 FD56 F0 0A                 BEQ   @2                       ;  - CONTROL-X 
1272 FD58 E0 F8                 CPX   #$F8
1273 FD5A 90 03                 BCC   @1                       ;MARGIN? 
1274 FD5C 20 3A FF              JSR   BELL                     ; YES, SOUND BELL 
1275 FD5F E8           @1       INX                            ;ADVANCE INPUT INDEX 
1276 FD60 D0 13                 BNE   NXTCHAR
1277 FD62
1278 FD62 A9 DC        @2       LDA   #$DC                     ;BACKSLASH AFTER CANCELLED LINE 
1279 FD64 20 ED FD              JSR   COUT
1280 FD67              GETLNZ   EQU   *                        ;Maintained entry point $FD67
1281 FD67 20 8E FD              JSR   CROUT                    ;Output carriage return
1282 FD6A              GETLN    EQU   *                        ;Maintained entry point $FD6A
1283 FD6A A5 33                 LDA   PROMPT                   ;Output prompt character
1284 FD6C              GETLN0   EQU   *                        ;Maintained entry point $FD6C
1285 FD6C 20 ED FD              JSR   COUT                     ;Output accumulator contents as prompt chr
1286 FD6F              GETLN1   EQU   *                        ;Maintained entry point $FD6F
1287 FD6F A2 01                 LDX   #$01                     ;INIT INPUT INDEX 
1288 FD71 8A           BCKSPC   TXA   
1289 FD72 F0 F3                 BEQ   GETLNZ                   ;WILL BACKSPACE TO 0 
1290 FD74 CA                    DEX   
1291 FD75 20 35 FD     NXTCHAR  JSR   RDCHAR
1292 FD78 C9 95                 CMP   #$95                     ;USE SCREEN CHAR
1293 FD7A D0 08                 BNE   @1                       ; FOR CONTROL-U
1294 FD7C B1 28                 LDA   (BASL),Y                 ;do 40 column pick
1295 FD7E 2C 1F C0              BIT   RD80VID                  ;80 columns?
1296 FD81 30 BD                 BMI   PICKFIX                  ;=>yes, fix it
1297 FD83 EA                    NOP                            ;Required filler
1298 FD84              @1       EQU   *
1299 FD84 20 BE FD              JSR   TESTDEL                  ;Test for delete then add to input buffer 
1300 FD87 C9 8D                 CMP   #$8D
1301 FD89 D0 BF                 BNE   NOTCR
1302 FD8B              CROUT1   EQU   *                        ;Maintained entry point $FD8B
1303 FD8B 20 9C FC              JSR   CLREOL                   ;CLR TO EOL IF CR 
1304 FD8E              CROUT    EQU   *                        ;Maintained entry point $FD8E
1305 FD8E A9 8D                 LDA   #$8D                     ;Output a carriage return
1306 FD90 80 5B                 BRA   COUT                     ;
1307 FD92
1308 FD92              PRA1     EQU   *                        ;Maintained entry point $FD92
1309 FD92 A4 3D                 LDY   A1H                      ;PRINT CR,A1 IN HEX 
1310 FD94 A6 3C                 LDX   A1L
1311 FD96 20 8E FD              JSR   CROUT
1312 FD99 20 40 F9     XPRADDR  JSR   PRNTYX
1313 FD9C A0 00                 LDY   #$00
1314 FD9E A9 BA                 LDA   #':'                     ;PRINT ':' 
1315 FDA0 80 4B                 BRA   COUT
1316 FDA2
1317 FDA2 20 75 FE     XAM8     JSR   DSPCOUNT
1318 FDA5 05 3C                 ORA   A1L
1319 FDA7 85 3E                 STA   A2L                      ; MOD 8=7 
1320 FDA9 A5 3D                 LDA   A1H
1321 FDAB 85 3F                 STA   A2H
1322 FDAD              XAM      EQU   *
1323 FDAD 4C 6D FE              JMP   TONEWRTNS                ;Off to new routine entry points
1324 FDB0
1325 FDB0              XAMPM    EQU   *                        ;DETERMINE IF MONITOR MODE IS 
1326 FDB0 48                    PHA                            ;Set/clear 'z'
1327 FDB1 68                    PLA                            ;
1328 FDB2 F0 F9                 BEQ   XAM                      ;= then doing carriage return
1329 FDB4 C9 AE                 CMP   #'.'                     ;Examine mode?
1330 FDB6 F0 F5                 BEQ   XAM                      ; EXAMINE, ADD OR SUBTRACT  
1331 FDB8 5A                    PHY                            ;Preserve 'Y' around call
1332 FDB9 A0 A1                 LDY   #$A1                     ;'Y'=$A1 for math calls
1333 FDBB 4C 73 F9              JMP   GETLENGTH2               ;Do routine+restore 'Y' and return
1334 FDBE
1335 FDBE              TESTDEL  EQU   *                        ;Test for delete/backspace key pressed
1336 FDBE C9 FF                 CMP   #$FF                     ;$FF= delete/backspace key
1337 FDC0 D0 11                 BNE   @2                       ;<>= delete or backspace
1338 FDC2 EB                    XBA                            ;Save 'A' in case we must use it
1339 FDC3 AF 37 01 E1           LDA   >CHGCURFLG               ;If changing cursor do NOT change del char
1340 FDC7 0A                    ASL   A                        ;Set/clear 'c'
1341 FDC8 EB                    XBA                            ;Restore 'A'
1342 FDC9 90 06                 BCC   @1                       ;
1343 FDCB 2C 1F C0              BIT   RD80VID                  ;If 80 columns on then convert $FF to $00
1344 FDCE 10 03                 BPL   @2                       ;'+' then 40 columns
1345 FDD0 1A                    INC   A                        ;Increment $FF to $00 if in 80 columns
1346 FDD1              @1       EQU   *
1347 FDD1 29 88                 AND   #$88                     ;Convert $FF to $88 (delete to left arrow)
1348 FDD3              @2       EQU   *
1349 FDD3 9D 00 02              STA   IN,X                     ;Save in input buffer
1350 FDD6 60                    RTS                            ;Back to caller
1351 FDD7
1352 FDD7
1353 FDD7 4C 46 FC     TONEWVW  JMP   NEWVW                    ;new entry to vidwait
1354 FDDA
1355 FDDA
1356 FDDA                       FillTo $FDDA                   ;Pad
1357 FDDA
1358 FDDA
1359 FDDA              PRBYTE   EQU   *                        ;Maintained entry point $FDDA
1360 FDDA 48                    PHA                            ;PRINT BYTE AS 2 HEX DIGITS 
1361 FDDB 4A                    LSR   A                        ; (DESTROYS A-REG) 
1362 FDDC 4A                    LSR   A
1363 FDDD 4A                    LSR   A
1364 FDDE 4A                    LSR   A
1365 FDDF 20 E5 FD              JSR   PRHEXZ
1366 FDE2 68                    PLA   
1367 FDE3              PRHEX    EQU   *                        ;Maintained entry point $FDE3
1368 FDE3 29 0F                 AND   #$0F                     ;PRINT HEX DIGIT IN A-REG 
1369 FDE5 09 B0        PRHEXZ   ORA   #$B0                     ;LSBITS ONLY. 
1370 FDE7 C9 BA                 CMP   #$BA
1371 FDE9 90 02                 BCC   COUT
1372 FDEB 69 06                 ADC   #$06
1373 FDED
1374 FDED              COUT     EQU   *                        ;Maintained entry point $FDED
1375 FDED 6C 36 00              JMP   (CSWL)                   ;Output via output hooks
1376 FDF0
1377 FDF0              COUT1    EQU   *                        ;Maintained entry point $FDF0
1378 FDF0 48                    PHA                            ;save original character
1379 FDF1 C9 A0                 CMP   #$A0                     ;is it a control?
1380 FDF3 4C 74 FC              JMP   DOCOUT1                  ;=>mask if not; return to COUTZ1
1381 FDF6
1382 FDF6              COUTZ    EQU   *                        ;Maintained entry point $FDF6
1383 FDF6 48                    PHA                            ;save original character
1384 FDF7 84 35        COUTZ1   STY   YSAV1                    ;save Y
1385 FDF9 A8                    TAY                            ;save masked character
1386 FDFA 68                    PLA                            ;get original char
1387 FDFB 80 DA                 BRA   TONEWVW                  ;new entry to vidwait
1388 FDFD
1389 FDFD C6 34        BL1      DEC   YSAV
1390 FDFF F0 A1                 BEQ   XAM8
1391 FE01 CA           BLANK    DEX                            ;BLANK TO MON 
1392 FE02 D0 0C                 BNE   SETMDZ                   ;AFTER BLANK 
1393 FE04 C9 BA                 CMP   #':'                     ;DATA STORE MODE? 
1394 FE06 D0 A8                 BNE   XAMPM                    ; NO; XAM, ADD, OR SUBTRACT. 
1395 FE08 4C DA FE              JMP   STOR                     ;= then user wants to do a store
1396 FE0B
1397 FE0B A4 34        SETMODE  LDY   YSAV                     ;SAVE CONVERTED ':','+','*','_'
1398 FE0D B9 FF 01              LDA   IN-1,Y                   ; '-', '.' AS MONMODE 
1399 FE10 85 31        SETMDZ   STA   MONMODE
1400 FE12 60                    RTS   
1401 FE13
1402 FE13              USR      EQU   *
1403 FE13 18                    CLC                            ;Switch to native mode for long jmp
1404 FE14 FB                    XCE                            ;
1405 FE15 5C A0 00 E1           JMP   >CTRLYVECTOR             ;If no routine hooked in then return
1406 FE19
1407 FE19              USR2~Bnk00 EQU   *-Rel~Org+Bnk~Org      ;Returns here if no routine
1408 FE19 38                    SEC                            ;Switch to emulation mode
1409 FE1A FB                    XCE                            ;
1410 FE1B 4C F8 03              JMP   USRADR                   ;JUMP TO CONTROL-Y VECTOR IN RAM 
1411 FE1E
1412 FE1E                       FillTo $FE1F                   ;Pad
1413 FE1F
1414 FE1F
1415 FE1F
1416 FE1F                       TITLE 'Auto-Start Monitor ROM'
1417 FE1F              *****************************************
1418 FE1F              *                                       *
1419 FE1F              *               APPLE II                *
1420 FE1F              *              MONITOR II               *
1421 FE1F              *                                       *
1422 FE1F              *    Copyright 1978, 1981, 1984-1989    *
1423 FE1F              *                   by                  *
1424 FE1F              *          Apple Computer, Inc.         *
1425 FE1F              *                                       *
1426 FE1F              *          All Rights Reserved          *
1427 FE1F              *                                       *
1428 FE1F              *       S. Wozniak             1977     *
1429 FE1F              *       A. Baum                1977     *
1430 FE1F              *       John A            Nov  1978     *
1431 FE1F              *       R. Auricchio      Sep  1981     *
1432 FE1F              *       E. Beernink            1984     *
1433 FE1F              *       E.K. Lai          Sep  1984     *
1434 FE1F              *       F. Bachman          1985-1987   *
1435 FE1F              *       Joe Bo              1988-1989   *
1436 FE1F              *                                       *
1437 FE1F              *****************************************
1438 FE1F
1439 FE1F
1440 FE1F              IDROUTINE EQU   *
1441 FE1F AD 55 FB              LDA   REGIDA                   ;Register identification for 'A'
1442 FE22 AE 57 FB              LDX   REGIDX                   ;Register identification for 'X'
1443 FE25 AC 59 FB              LDY   REGIDY                   ;Register identification for 'Y'
1444 FE28 18                    CLC                            ;'C'=0 means this in not a //e or //c
1445 FE29 60                    RTS                            ;Back to caller
1446 FE2A
1447 FE2A                       FillTo $FE2C                   ;Pad
1448 FE2C
1449 FE2C              MOVE     EQU   *                        ;Maintained entry point $FE2C
1450 FE2C B1 3C                 LDA   (A1L),Y                  ;MOVE (A1) THRU (A2) TO (A4) 
1451 FE2E 91 42                 STA   (A4L),Y
1452 FE30 20 B4 FC              JSR   NXTA4
1453 FE33 90 F7                 BCC   MOVE
1454 FE35 60                    RTS   
1455 FE36
1456 FE36              NEWRESET EQU   *                        ;Dummy up int stack pointers
1457 FE36 18                    CLC                            ;Switch to native mode for JSL
1458 FE37 FB                    XCE                            ;
1459 FE38 22 00 76 FF           JSL   >SPELRESET               ;Special power up reset
1460 FE3C 38                    SEC                            ;Switch back to emulation mode
1461 FE3D FB                    XCE                            ;
1462 FE3E A0 A3                 LDY   #$A3                     ;'Y'=$A3 for setting up BATTERYRAM stuff
1463 FE40 20 9C F8              JSR   GOTOBANKFF               ;
1464 FE43
1465 FE43              SETVIDKBD EQU   *                       ;Set up 40 column video and keyboard
1466 FE43 20 84 FE              JSR   SETNORM                  ;Set normal character output
1467 FE46 20 2F FB              JSR   INIT                     ;Set up some parameters
1468 FE49 20 93 FE              JSR   SETVID                   ;Set video as output
1469 FE4C 80 3B                 BRA   SETKBD                   ;Set keyboard as input
1470 FE4E
1471 FE4E              GOTXT1   EQU   *                        ;Go to Text page 1
1472 FE4E              ;LDA #$80 ;No super hi res screen
1473 FE4E              ;TRB NEWVIDEO ;
1474 FE4E              ;LDA TXTSET ;Enable text
1475 FE4E              ;LDA MIXCLR ;Clear mixed mode
1476 FE4E              ;STZ WNDTOP ;Reset top of window
1477 FE4E              ;BRA GOTXT2 ;Continue this way
1478 FE4E A0 A9                 LDY   #$A9
1479 FE50 4C 9C F8              JMP   GOTOBANKFF
1480 FE53              GOTXT11  EQU   *
1481 FE53 A0 AA                 LDY   #$AA
1482 FE55 4C 9C F8              JMP   GOTOBANKFF
1483 FE58
1484 FE58                       FillTo $FE5E                   ;Pad
1485 FE5E
1486 FE5E              VFY      EQU   *                        ;Maintained entry point $FE5E
1487 FE5E A0 83                 LDY   #$83                     ;Do new verify in bank FF
1488 FE60 80 11                 BRA   TONEWRTNS2               ;Go to it
1489 FE62
1490 FE62 8A           A1PC     TXA                            ;IF USER SPECIFIED AN ADDRESS, 
1491 FE63 F0 07                 BEQ   @2                       ; COPY IT FROM A1 TO PC. 
1492 FE65 B5 3C        @1       LDA   A1L,X                    ;YEP, SO COPY IT. 
1493 FE67 95 3A                 STA   PCL,X
1494 FE69 CA                    DEX   
1495 FE6A 10 F9                 BPL   @1
1496 FE6C 60           @2       RTS   
1497 FE6D
1498 FE6D
1499 FE6D              TONEWRTNS EQU   *
1500 FE6D 48                    PHA                            ;Preserve 'A'
1501 FE6E 98                    TYA                            ;Convert $0Y to $8Y
1502 FE6F 09 80                 ORA   #$80                     ;
1503 FE71 A8                    TAY                            ;
1504 FE72 68                    PLA                            ;Restore 'A'
1505 FE73              TONEWRTNS2 EQU   *
1506 FE73 80 36                 BRA   IOPRT2                   ;Off to routine
1507 FE75
1508 FE75              * Determine whether to display 8 or 16 bytes
1509 FE75
1510 FE75              DSPCOUNT EQU   *
1511 FE75 A5 21                 LDA   WNDWDTH                  ;How many columns?
1512 FE77 C9 48                 CMP   #72                      ;> or = to 72 columns
1513 FE79 A9 0F                 LDA   #$0F                     ;Anticipate 16 fields of data to display
1514 FE7B B0 02                 BCS   @1                       ;'c' from CMP above
1515 FE7D A9 07                 LDA   #$07                     ;'c'=0 then display 8 fields of data only
1516 FE7F              @1       EQU   *
1517 FE7F 60                    RTS                            ;Back to caller
1518 FE80
1519 FE80                       FillTo $FE80                   ;Pad
1520 FE80
1521 FE80              SETINV   EQU   *                        ;Maintained entry point $FE80
1522 FE80 A0 3F                 LDY   #$3F                     ;SET FOR INVERSE VID 
1523 FE82 D0 02                 BNE   SETIFLG                  ; VIA COUT1 
1524 FE84              SETNORM  EQU   *                        ;Maintained entry point $FE84
1525 FE84 A0 FF                 LDY   #$FF                     ;SET FOR NORMAL VID 
1526 FE86 84 32        SETIFLG  STY   INVFLG
1527 FE88 60                    RTS   
1528 FE89
1529 FE89              SETKBD   EQU   *                        ;Maintained entry point $FE89
1530 FE89 A9 00                 LDA   #$00                     ;DO 'IN#0'
1531 FE8B              INPORT   EQU   *                        ;Maintained entry point $FE8B
1532 FE8B 85 3E                 STA   A2L                      ;DO 'IN#AREG' 
1533 FE8D A2 38        INPRT    LDX   #KSWL
1534 FE8F A0 1B                 LDY   #KEYIN
1535 FE91 D0 08                 BNE   IOPRT
1536 FE93
1537 FE93              SETVID   EQU   *                        ;Maintained entry point $FE93
1538 FE93 A9 00                 LDA   #$00                     ;DO 'PR#0' 
1539 FE95              OUTPORT  EQU   *                        ;Maintained entry point $FE95
1540 FE95 85 3E                 STA   A2L                      ;DO 'PR#AREG' 
1541 FE97 A2 36        OUTPRT   LDX   #CSWL
1542 FE99 A0 F0                 LDY   #COUT1
1543 FE9B A5 3E        IOPRT    LDA   A2L                      ;SET INPUT/OUTPUT VECTORS
1544 FE9D 29 0F                 AND   #$0F
1545 FE9F F0 04                 BEQ   @1
1546 FEA1 09 C0                 ORA   #>IOADR
1547 FEA3 A0 00                 LDY   #$00
1548 FEA5 94 00        @1       STY   LOC0,X                   ;save low byte of hook
1549 FEA7 95 01                 STA   LOC1,X                   ;save acc 
1550 FEA9 A0 0E                 LDY   #$E                      ;code=PR#/IN#
1551 FEAB 80 36        IOPRT2   BRA   GOTOFF4                  ; branch always
1552 FEAD
1553 FEAD 4C 03 E0     BASCONT  JMP   BASIC2                   ;TO BASIC, WARM START 
1554 FEB0
1555 FEB0              GOTXT2   EQU   *
1556 FEB0 AD 54 C0              LDA   TXTPAGE1                 ;Enable text page 1
1557 FEB3 60                    RTS                            ;Back to caller
1558 FEB4
1559 FEB4              MONDSKACC EQU   *                       ;Enable the monitor desk accessory
1560 FEB4 80 5A                 BRA   MONDSKACC2               ;Must have entry point in $FExx 
1561 FEB6
1562 FEB6                       FillTo $FEB6                   ;Pad
1563 FEB6
1564 FEB6              GO       EQU   *                        ;Maintained entry point $FEB6
1565 FEB6 20 62 FE              JSR   A1PC                     ;Address to PC if specified
1566 FEB9 20 3F FF              JSR   RESTORE                  ;Restore fake registers
1567 FEBC 6C 3A 00              JMP   (PCL)                    ; and execute routine.
1568 FEBF
1569 FEBF              QUITMON  EQU   *
1570 FEBF AD D0 03              LDA   OSWMSTRT                 ;Test if JMP opcode installed
1571 FEC2 C9 4C                 CMP   #$4C                     ;JMP opcode
1572 FEC4 F0 01                 BEQ   @1                       ;= then restart operating system
1573 FEC6 60                    RTS                            ;Back to monitor
1574 FEC7
1575 FEC7              @1       EQU   *
1576 FEC7 4C D0 03              JMP   OSWMSTRT                 ;Warmstart operating system
1577 FECA
1578 FECA              NEWREGZ  EQU   *
1579 FECA 4C D7 FA              JMP   REGDSP                   ;Go do new register display
1580 FECD
1581 FECD                       FillTo $FECD                   ;Pad
1582 FECD
1583 FECD              WRITE    EQU   *                        ;Maintained entry point $FECD
1584 FECD 60                    RTS                            ;Dummy routine
1585 FECE
1586 FECE
1587 FECE C8           MAKENATIVE INY                          ;'Y' = $91 for default 'm'/'x'/'e' = 0
1588 FECF C8           UTILITY  INY                            ;'Y' = $90 for utility call to Tools
1589 FED0 C8           X816     INY                            ;'Y' = $8F for execute JSL subroutine
1590 FED1 C8           GO816    INY                            ;'Y' = $8E for go JSR subroutine
1591 FED2 C8           LITASC   INY                            ;'Y' = $8D for literal ASCII input mode
1592 FED3 C8           CMDZAP   INY                            ;'Y' = $8C for Zap memory command
1593 FED4 C8           PTRNSET  INY                            ;'Y' = $8B for set pattern for search
1594 FED5 C8           LIST     INY                            ;'Y' = $8A for list
1595 FED6 C8           EQUALS   INY                            ;'Y' = $89 for equals
1596 FED7 C8           RESUME   INY                            ;'Y' = $88 for new resume
1597 FED8 C8           STEP     INY                            ;'Y' = $87 for step
1598 FED9 C8           TRACE    INY                            ;'Y' = $86 for trace
1599 FEDA C8           STOR     INY                            ;'Y' = $85 for store
1600 FEDB C8           MINI     INY                            ;'Y' = $84 for miniassembler
1601 FEDC C8           XVERIFY  INY                            ;'Y' = $83 for verify
1602 FEDD C8           XMOVE    INY                            ;'Y' = $82 for move
1603 FEDE C8           SEARCH   INY                            ;'Y' = $81 for pattern search
1604 FEDF 80 8C                 BRA   TONEWRTNS                ;Continue this way
1605 FEE1
1606 FEE1              REGSET   EQU   *                        ;Sets up registers for monitor entry
1607 FEE1 A0 96                 LDY   #$96                     ;'Y'=$96 for register setup for monitor
1608 FEE3 4C 9C F8     GOTOFF4  JMP   GOTOBANKFF               ;perform call
1609 FEE6
1610 FEE6              NEWFIXSEV EQU   *
1611 FEE6 8C F2 03              STY   SOFTEV
1612 FEE9 20 D2 F9              JSR   WARMUPAPTALK             ;Enable DATAREG ints for desk acc mgr
1613 FEEC 4C 00 E0     XBASIC   JMP   BASIC                    ;TO BASIC, COLD START 
1614 FEEF
1615 FEEF              ESC1_1   EQU   *
1616 FEEF 68                    PLA                            ;Remove 1 RTS from stack
1617 FEF0 68                    PLA                            ;
1618 FEF1 A9 98                 LDA   #$98                     ;Cancel the line with control-X
1619 FEF3 4C ED FD              JMP   COUT                     ;Causes shift to 80 columns
1620 FEF6
1621 FEF6 20 FD FD     CRMON    JSR   BL1                      ;HANDLE CR AS BLANK 
1622 FEF9 68                    PLA                            ; THEN POP STACK 
1623 FEFA 68                    PLA                            ; AND RETURN TO MON 
1624 FEFB 80 6F                 BRA   MONZ2                    ;Exit to monitor
1625 FEFD
1626 FEFD                       FillTo $FEFD                   ;Pad
1627 FEFD
1628 FEFD              READ     EQU   *                        ;Maintained entry point $FEFD
1629 FEFD 60                    RTS                            ;Dummy routine
1630 FEFE
1631 FEFE AF 3E 01 E1  LT       LDA   >BANKS
1632 FF02 8F 3F 01 E1           STA   >BANKD
1633 FF06 A2 01                 LDX   #$01
1634 FF08 B5 3E        @1       LDA   A2L,X                    ;COPY A2 (2 BYTES) TO  
1635 FF0A 95 42                 STA   A4L,X                    ; A4 AND A5 
1636 FF0C CA                    DEX   
1637 FF0D 10 F9                 BPL   @1
1638 FF0F 60                    RTS   
1639 FF10
1640 FF10              MONDSKACC2 EQU   *                      ;Enable the monitor desk accessory
1641 FF10 C8                    INY                            ;'Y' = $92 for install monitor desk acc
1642 FF11 80 BB                 BRA   MAKENATIVE               ;Continue in regular loop
1643 FF13
1644 FF13                       FillTo $FF13                   ;Pad
1645 FF13
1646 FF13              * NNBL gets the next non-blank for the mini-assembler
1647 FF13
1648 FF13 20 CA FC     NNBL     JSR   UPMON                    ;get char, upshift, INY
1649 FF16 C9 A0                 CMP   #$A0                     ;is it blank?
1650 FF18 F0 F9                 BEQ   NNBL                     ;yes, keep looking
1651 FF1A 60                    RTS   
1652 FF1B
1653 FF1B B0 6D        LOOKASC  BCS   DIG                      ;it was a digit
1654 FF1D C9 A0                 CMP   #$A0                     ;check for quote (')
1655 FF1F D0 28                 BNE   RTS6                     ;nope, return char
1656 FF21 B9 00 02              LDA   IN,Y                     ;else get next char
1657 FF24 A2 07                 LDX   #7                       ;for shifting asc into A2L and A2H
1658 FF26 C9 8D                 CMP   #$8D                     ;was it CR?
1659 FF28 F0 7D                 BEQ   GETNUM                   ;yes, go handle CR
1660 FF2A C8                    INY                            ;advance index
1661 FF2B D0 63                 BNE   NXTBIT                   ;=>(always) into A2L and A2H
1662 FF2D
1663 FF2D                       FillTo $FF2D                   ;Pad
1664 FF2D
1665 FF2D              PRERR    EQU   *                        ;Maintained entry point $FF2D
1666 FF2D A9 C5                 LDA   #$C5                     ;Print 'ERR', then fall into beeper.
1667 FF2F 20 ED FD              JSR   COUT                     ;
1668 FF32 A9 D2                 LDA   #$D2
1669 FF34 20 ED FD              JSR   COUT
1670 FF37 20 ED FD              JSR   COUT
1671 FF3A
1672 FF3A              BELL     EQU   *                        ;Maintained entry point $FF3A
1673 FF3A A9 87                 LDA   #$87                     ;MAKE A JOYFUL NOISE, THEN RETURN. 
1674 FF3C 4C ED FD              JMP   COUT
1675 FF3F
1676 FF3F              RESTORE  EQU   *                        ;Maintained entry point $FF3F
1677 FF3F A5 48                 LDA   STATUS                   ;RESTORE 6502 REGISTER CONTENTS 
1678 FF41 48                    PHA                            ;
1679 FF42 A5 45                 LDA   A5H
1680 FF44 A6 46                 LDX   XREG                     ;Was label RESTR1
1681 FF46 A4 47                 LDY   YREG
1682 FF48 28                    PLP   
1683 FF49 60           RTS6     RTS   
1684 FF4A
1685 FF4A              SAVE     EQU   *                        ;Maintained entry point $FF4A
1686 FF4A 85 45                 STA   A5H                      ;SAVE 6502 REGISTER CONTENTS 
1687 FF4C 86 46        SAV1     STX   XREG                     ;
1688 FF4E 84 47                 STY   YREG
1689 FF50 08                    PHP   
1690 FF51 68                    PLA   
1691 FF52 85 48                 STA   STATUS
1692 FF54 BA                    TSX   
1693 FF55 86 49                 STX   SPNT
1694 FF57 D8                    CLD   
1695 FF58              IORTS    EQU   *                        ;Maintained entry point $FF58
1696 FF58 60                    RTS   
1697 FF59
1698 FF59              OLDRST   EQU   *                        ;Maintained entry point $FF59
1699 FF59 20 43 FE              JSR   SETVIDKBD                ;Init keyboard and video
1700 FF5C 80 07                 BRA   MON                      ;Skip fill buffer
1701 FF5E
1702 FF5E              SETPRMPT EQU   *                        ;Set up monitor prompt
1703 FF5E A9 AA                 LDA   #$AA                     ;'*' PROMPT FOR MONITOR 
1704 FF60 85 33                 STA   PROMPT
1705 FF62 4C 67 FD              JMP   GETLNZ                   ;Exit by getting a line of input
1706 FF65
1707 FF65                       FillTo $FF65                   ;Pad
1708 FF65
1709 FF65              MON      EQU   *                        ;Maintained entry point $FF65
1710 FF65 D8                    CLD                            ;MUST SET HEX MODE! 
1711 FF66 4C 43 FA              JMP   OLDBRK2                  ;Beep the speaker/skip REGSET
1712 FF69
1713 FF69
1714 FF69              * Enter here for normal monitor mode.
1715 FF69              * All registers/modes set up to default on entry here.
1716 FF69
1717 FF69              MONZ     EQU   *                        ;Maintained entry point $FF69
1718 FF69 20 E1 FE              JSR   REGSET                   ;Set up registers
1719 FF6C
1720 FF6C              * Enter here for last monitor mode.
1721 FF6C              * All registers/modes same as last time user exited monitor.
1722 FF6C
1723 FF6C              MONZ2    EQU   *                        ;Maintained entry point $FF6C
1724 FF6C EA                    NOP                            ;Required filler to make entry pnts match
1725 FF6D 20 5E FF              JSR   SETPRMPT                 ;Set up prompt char/read an input line
1726 FF70              MONZ4    EQU   *                        ;Maintained entry point $FF70
1727 FF70 20 D1 FF              JSR   ZMODEYSAV                ;Clear monitor mode, scan idx, YSAV
1728 FF73              NXTITM   EQU   *                        ;Get next item, non-HEX
1729 FF73 20 88 F8              JSR   GONEWGETNUM              ;Use new getnum routine
1730 FF76 84 34                 STY   YSAV
1731 FF78 A0 25                 LDY   #CHRTBLLEN+1             ; X-REG=0 IF NO HEX INPUT 
1732 FF7A 88           @1       DEY                            ;Character search loop
1733 FF7B 30 E8                 BMI   MON                      ;COMMAND NOT FOUND, BEEP & TRY AGAIN. 
1734 FF7D D9 88 F9              CMP   CHRTBL,Y                 ;FIND COMMAND CHAR IN TABLE 
1735 FF80 D0 F8                 BNE   @1                       ;NOT THIS TIME 
1736 FF82 20 BE FF              JSR   TOSUB                    ;GOT IT! CALL CORRESPONDING SUBROUTINE 
1737 FF85 A4 34                 LDY   YSAV                     ;PROCESS NEXT ENTRY ON HIS LINE 
1738 FF87 4C 73 FF              JMP   NXTITM                   ;JMP for code alignment
1739 FF8A
1740 FF8A              DIG      EQU   *                        ;Maintained entry point $FF8A
1741 FF8A A2 03                 LDX   #$03
1742 FF8C 0A                    ASL   A
1743 FF8D 0A                    ASL   A                        ;GOT HEX DIGIT, 
1744 FF8E 0A                    ASL   A                        ; SHIFT INTO A2 
1745 FF8F 0A                    ASL   A
1746 FF90 0A           NXTBIT   ASL   A                        ;Shift in next bit loop
1747 FF91 26 3E                 ROL   A2L
1748 FF93 26 3F                 ROL   A2H
1749 FF95 CA                    DEX                            ;LEAVE X=$FF IF DIG 
1750 FF96 10 F8                 BPL   NXTBIT
1751 FF98 A5 31        @2       LDA   MONMODE
1752 FF9A D0 06                 BNE   @3                       ;IF MODE IS ZERO, 
1753 FF9C B5 3F                 LDA   A2H,X                    ; THEN COPY A2 TO A1 AND A3 
1754 FF9E 95 3D                 STA   A1H,X
1755 FFA0 95 41                 STA   A3H,X
1756 FFA2 E8           @3       INX   
1757 FFA3 F0 F3                 BEQ   @2
1758 FFA5 D0 06                 BNE   NXTCHR
1759 FFA7
1760 FFA7              GETNUM   EQU   *                        ;Maintained entry point $FFA7
1761 FFA7 A2 00                 LDX   #$00                     ;CLEAR A2 
1762 FFA9 86 3E                 STX   A2L
1763 FFAB 86 3F                 STX   A2H
1764 FFAD              NXTCHR   EQU   *                        ;Maintained entry point $FFAD
1765 FFAD 20 CA FC              JSR   UPMON                    ;get char, upshift, INY
1766 FFB0 EA                    NOP                            ;REQUIRED filler for compatibility
1767 FFB1 49 B0                 EOR   #$B0
1768 FFB3 C9 0A                 CMP   #$0A
1769 FFB5 90 D3                 BCC   DIG                      ;BR IF HEX DIGIT 
1770 FFB7 69 88                 ADC   #$88
1771 FFB9 C9 FA                 CMP   #$FA
1772 FFBB 4C 1B FF              JMP   LOOKASC                  ;check for ASCII input
1773 FFBE
1774 FFBE
1775 FFBE                       FillTo $FFBE                   ;Pad
1776 FFBE
1777 FFBE              TOSUB    EQU   *                        ;Maintained entry point $FFBE
1778 FFBE A9 FE                 LDA   #>GO                     ;DISPATCH TO SUBROUTINE, BY 
1779 FFC0 48                    PHA                            ; PUSHING THE HI-ORDER SUBR ADDR, 
1780 FFC1 B9 AD F9              LDA   SUBTBL,Y                 ; THEN THE LO-ORDER SUBR ADDR 
1781 FFC4 48                    PHA                            ; ONTO THE STACK, 
1782 FFC5 A5 31                 LDA   MONMODE                  ; (CLEARING THE MONMODE, SAVE THE OLD 
1783 FFC7              ZMODE    EQU   *                        ;Maintained entry point $FFC7
1784 FFC7 A0 00                 LDY   #$00                     ; MONMODE IN A-REG), 
1785 FFC9 84 31                 STY   MONMODE
1786 FFCB              PRODOSRTS EQU   *                       ;Maintained entry point $FFCB
1787 FFCB 60                    RTS                            ; AND 'RTS' TO THE SUBROUTINE! 
1788 FFCC
1789 FFCC              GETLENGTH EQU   *                       ;Preset 'Y' to 00
1790 FFCC A0 00                 LDY   #$00
1791 FFCE 80 20                 BRA   TOGETLENGTH
1792 FFD0
1793 FFD0                       FillTo $FFD0                   ;Pad
1794 FFD0
1795 FFD0              DOSEF    EQU   *                        ;Maintained entry point $FFD0
1796 FFD0 EF                    DC B:$EF                       ;V   (MEMORY VERIFY) 
1797 FFD1
1798 FFD1              ZMODEYSAV EQU   *
1799 FFD1 64 34                 STZ   YSAV                     ;Must zero entry point into the input
1800 FFD3 20 C7 FF              JSR   ZMODE                    ; buffer and zero out monitor mode.
1801 FFD6
1802 FFD6              FIXSPEED EQU   *
1803 FFD6 AD 36 C0              LDA   CYAREG                   ;Be sure system speed is correct
1804 FFD9 29 7F                 AND   #$7F                     ;Reset hi bit in case 'slow' (Yuk!) speed
1805 FFDB              FIXSPEED2 EQU   *
1806 FFDB 0F 38 01 E1           ORA   >SYSTEMSPD               ; as per user instructions.
1807 FFDF 8D 36 C0              STA   CYAREG                   ;
1808 FFE2 60                    RTS                            ;Back to caller
1809 FFE3
1810 FFE3                       FillTo $FFE4                   ;Pad
1811 FFE4
1812 FFE4              NCOP     EQU   *                        ;Maintained entry point $FFE4
1813 FFE4 7B C0                 DC W:TONCOP                    ;Native COP interrupt vector
1814 FFE6              NBREAK   EQU   *                        ;Maintained entry point $FFE6
1815 FFE6 71 C0                 DC W:TONBREAK                  ;Native break interrupt vector
1816 FFE8              NABORT   EQU   *                        ;Maintained entry point $FFE8
1817 FFE8 79 C0                 DC W:TONABORT                  ;Native abort interrupt vector
1818 FFEA              NNMI     EQU   *                        ;Maintained entry point $FFEA
1819 FFEA FB 03                 DC W:NMI                       ;Native non-maskable interrupt vector
1820 FFEC E6 E2                 DC B:$E6,$E2                   ;Required
1821 FFEE              NIRQ     EQU   *                        ;Maintained entry point $FFEE
1822 FFEE 74 C0                 DC W:TONIRQ                    ;Native IRQ interrupt vector
1823 FFF0
1824 FFF0              TOGETLENGTH EQU   *
1825 FFF0 4C 6C F9              JMP   GETLENGTH1               ;Continue with normal code
1826 FFF3 00                    DC B:0                         ;Required filler
1827 FFF4
1828 FFF4              ECOP     EQU   *                        ;Maintained entry point $FFF4
1829 FFF4 7B C0                 DC W:TOECOP                    ;Emulation COP interrupt vector
1830 FFF6
1831 FFF6              CHKSUMTWEAK EQU   *
1832 FFF6 50 62                 DC W:$6250                     ;Modify to make bank FE/FF checksum=$1234
1833 FFF8
1834 FFF8              EABORT   EQU   *                        ;Maintained entry point $FFF8
1835 FFF8 79 C0                 DC W:TOEABORT                  ;Emulation abort interrupt vector
1836 FFFA              ENMI     EQU   *                        ;Maintained entry point $FFFA
1837 FFFA FB 03                 DC W:NMI                       ;Emulation non-maskable interrupt vector
1838 FFFC              ERESET   EQU   *                        ;Maintained entry point $FFFC
1839 FFFC 62 FA                 DC W:RESET                     ;Reset vector  
1840 FFFE              EBRKIRQ  EQU   *                        ;Maintained entry point $FFFE
1841 FFFE              **********************************************************************
1842 FFFE              ; AsmIIgs generates an ERROR if you assemble the last byte of the address space
1843 FFFE              ; and thus "wrap" the address space from $FF/FFFF to $00/0000 and this error 
1844 FFFE              ; prevents the generation of the output object file!!!! 
1845 FFFE              ; THIS IS A BUG!!!!!!
1846 FFFE              **********************************************************************
1847 FFFE              ; See the silly 1 word PROC that follows!
1848 FFFE              ;		DC.W	TOEBRKIRQ	;Emulation break/IRQ interrupt vector
1849 FFFE              **********************************************************************
